/*
 * Main.java
 *
 * Copyright (C) August Mayer, 2001-2004. All rights reserved.
 * Please consult the Boone LICENSE file for additional rights granted to you.
 *
 * Created on 25. November 2002, 14:47
 */

package samples.programs;

import boone.NeuralNet;
import boone.PatternSet;
import boone.Trainer;
import boone.io.IOFilter;
import boone.io.SNNSPatternFilter;
import boone.structure.NetFactory;
import boone.training.AdamTrainer;

import java.io.File;
import java.io.IOException;

/**
 * Test program: load a benchmark pattern pattern file and train a network with it.
 *
 * @author Helmut Mayer
 * @version $Id$
 */
public class BenchTest {

    /**
     * Loads a benchmark, constructs a net and trains the net.
     *
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        System.out.println("Loading Proben1 file 'samples/data/heart1.dt'...");

        IOFilter filter = new SNNSPatternFilter();
        File file = new File("samples/data/snns_test1.pat");
        PatternSet heartSet = new PatternSet(filter);

        try {
            heartSet.load(file);
        } catch (IOException e) {
            e.printStackTrace();
            return;
        }
//		heartSet = heartSet.subSet(0, 100);									// split the set into training
//		PatternSet trainSet = heartSet.subSet(0, 690);						// split the set into training
//		PatternSet testSet = heartSet.subSet(690, 920);						// and test set

        System.out.println("*** Creating feed forward network...");

        NeuralNet net = NetFactory.createFeedForward(new int[]{2, 10, 10, 2}, false, new AdamTrainer(), null, null);

        int steps = 20;
        int epochs = 100;
        Trainer trainer = net.getTrainer();
        System.out.println("Trainer: " + trainer);

        trainer.setTrainingData(heartSet);
        trainer.setTestData(heartSet);
        //        trainer.setBatchSize(32);
        //		trainer.setLearnRate(0.0005);
        trainer.setEpochs(epochs);
        trainer.setStepMode(true);                                                    // training in steps
        System.out.println("*** Training " + (steps * epochs) + " epochs...");
//		trainer.setShuffle(true);
//		((BackpropTrainer)trainer).setMomentum(0.8);
        System.out.println("Error: ");
        for (int i = 0; i < steps; i++) {
            trainer.train();
            System.out.println(((i + 1) * epochs) + ". - " + net.getTrainer().test());
        }

//		System.out.println("\n*** Testing the network...");
//
//		System.out.println();
//		for (int i = 0; i < heartSet.size(); i++)
//			System.out.println("Error " + i + " = " + net.getTrainer().test(heartSet.getInputs().get(i), heartSet.getTargets().get(i)));
//
//		System.out.println("Saving network");
//
//		try {
//			net.save(new File("test/samples/data/heart.xnet"));
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//		System.out.println("Printing the net:\n" + net);

        System.out.println("Done.");
    }

}
