/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.poi;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.ujmp.core.Matrix;
import org.ujmp.core.util.StringUtil;

public abstract class AbstractMatrixExcelExporter {
    public void exportToExcelFile(Workbook workbook, Matrix matrix, File file, String sheetName) throws IOException {
        Sheet sheet = workbook.createSheet(sheetName);
        int rowCount = (int)matrix.getRowCount();
        int columnCount = (int)matrix.getColumnCount();
        for (int r = 0; r < rowCount; ++r) {
            Row row = sheet.createRow(r);
            for (int c = 0; c < columnCount; ++c) {
                Object o = matrix.getAsObject(r, c);
                if (o == null) continue;
                Cell cell = row.createCell(c);
                if (o instanceof Double) {
                    cell.setCellValue(((Double)o).doubleValue());
                    continue;
                }
                if (o instanceof String) {
                    cell.setCellValue((String)o);
                    continue;
                }
                if (o instanceof Date) {
                    cell.setCellValue((Date)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    cell.setCellValue(((Boolean)o).booleanValue());
                    continue;
                }
                cell.setCellValue(StringUtil.convert(o));
            }
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        workbook.write((OutputStream)fileOutputStream);
        bufferedOutputStream.close();
        fileOutputStream.close();
    }
}

