/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.ojalgo.calculation;

import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.decomposition.SingularValueDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ujmp.core.Matrix;
import org.ujmp.ojalgo.OjalgoDenseDoubleMatrix2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVD
implements org.ujmp.core.doublematrix.calculation.general.decomposition.SVD<Matrix> {
    public static SVD INSTANCE = new SVD();

    public Matrix[] calc(Matrix source) {
        SingularValue svd = SingularValueDecomposition.makePrimitive();
        if (source instanceof OjalgoDenseDoubleMatrix2D) {
            svd.compute((Access2D)((OjalgoDenseDoubleMatrix2D)source).getWrappedObject());
        } else {
            svd.compute((Access2D)new OjalgoDenseDoubleMatrix2D(source).getWrappedObject());
        }
        OjalgoDenseDoubleMatrix2D u = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)svd.getQ1());
        OjalgoDenseDoubleMatrix2D s = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)svd.getD());
        OjalgoDenseDoubleMatrix2D v = new OjalgoDenseDoubleMatrix2D((MatrixStore<Double>)svd.getQ2());
        return new Matrix[]{u, s, v};
    }
}

