/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jung;

import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.EdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelRenderer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.commons.collections15.Transformer;
import org.ujmp.core.graphmatrix.GraphMatrix;
import org.ujmp.gui.MatrixGUIObject;
import org.ujmp.gui.panels.AbstractPanel;
import org.ujmp.gui.util.UIDefaults;
import org.ujmp.jung.ColorTransformer;
import org.ujmp.jung.EdgeWrapper;
import org.ujmp.jung.GraphMatrixWrapper;
import org.ujmp.jung.JungGraphActions;
import org.ujmp.jung.VertexIconTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JungVisualizationViewer<N, E>
extends AbstractPanel
implements MouseListener,
TableModelListener,
ComponentListener,
GraphMouseListener<N> {
    private static final long serialVersionUID = 7328433763448698033L;
    private final GraphMatrixWrapper<N, E> graph;
    private boolean showNodeLabels;
    private boolean showEdgeLabels;
    private final Transformer<N, String> emptyNodeLabelTransformer;
    private final Transformer<EdgeWrapper<E>, String> emptyEdgeLabelTransformer;
    private final VisualizationViewer<N, EdgeWrapper<E>> vv;
    private final Layout<N, EdgeWrapper<E>> layout;
    private final GraphMatrix<N, E> graphMatrix;
    private final MatrixGUIObject matrixGUIObject;

    public JungVisualizationViewer(GraphMatrixWrapper<N, E> graph, boolean showNodeLabels, boolean showEdgeLabels) {
        super(graph.getGraphMatrix().getGUIObject());
        this.graph = graph;
        this.graphMatrix = graph.getGraphMatrix();
        this.matrixGUIObject = (MatrixGUIObject)this.graphMatrix.getGUIObject();
        this.showNodeLabels = showNodeLabels;
        this.showEdgeLabels = showEdgeLabels;
        this.layout = graph.getVertexCount() < 1000 ? new FRLayout(graph) : new ISOMLayout(graph);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(this.layout);
        this.vv = new VisualizationViewer((VisualizationModel)visualizationModel);
        this.vv.setForeground(new Color(0, 0, 0, 150));
        this.vv.setBackground(Color.WHITE);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        graphMouse.setMode(ModalGraphMouse.Mode.PICKING);
        RenderContext rc = this.vv.getRenderContext();
        this.emptyNodeLabelTransformer = rc.getVertexLabelTransformer();
        this.emptyEdgeLabelTransformer = rc.getEdgeLabelTransformer();
        rc.setVertexIconTransformer(new VertexIconTransformer(this.vv.getPickedVertexState()));
        rc.setVertexFillPaintTransformer(new ColorTransformer(this.vv.getPickedVertexState()));
        rc.setVertexLabelRenderer((VertexLabelRenderer)new DefaultVertexLabelRenderer(UIDefaults.SELECTEDCOLOR));
        rc.setEdgeDrawPaintTransformer(new ColorTransformer(this.vv.getPickedEdgeState()));
        rc.setEdgeLabelRenderer((EdgeLabelRenderer)new DefaultEdgeLabelRenderer(UIDefaults.SELECTEDCOLOR));
        rc.setArrowFillPaintTransformer(new ColorTransformer(this.vv.getPickedEdgeState()));
        rc.setArrowDrawPaintTransformer(new ColorTransformer(this.vv.getPickedEdgeState()));
        this.vv.getRenderer().getVertexLabelRenderer().setPositioner((Renderer.VertexLabel.Positioner)new BasicVertexLabelRenderer.InsidePositioner());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        if (showNodeLabels) {
            rc.setVertexLabelTransformer((Transformer)new ToStringLabeller());
        }
        if (showEdgeLabels) {
            rc.setEdgeLabelTransformer((Transformer)new ToStringLabeller());
        }
        this.vv.setVertexToolTipTransformer((Transformer)new ToStringLabeller());
        this.setLayout(new BorderLayout());
        this.add((Component)this.vv, "Center");
        this.vv.addMouseListener((MouseListener)this);
        this.addComponentListener(this);
        this.vv.addGraphMouseListener((GraphMouseListener)this);
        if (graph instanceof GraphMatrixWrapper) {
            ((MatrixGUIObject)graph.getGraphMatrix().getGUIObject()).addTableModelListener(this);
        }
    }

    public JungVisualizationViewer(GraphMatrixWrapper<N, E> graph) {
        this(graph, graph.getVertexCount() < 100, graph.getVertexCount() < 100);
    }

    public JungVisualizationViewer(GraphMatrix<N, E> graphMatrix) {
        this(new GraphMatrixWrapper<N, E>(graphMatrix));
    }

    public JungVisualizationViewer(GraphMatrix<N, E> graphMatrix, boolean showNodeLabels, boolean showEdgeLabels) {
        this(new GraphMatrixWrapper<N, E>(graphMatrix), showNodeLabels, showEdgeLabels);
    }

    public void switchLayout(GraphLayout type) {
        KKLayout layout = null;
        switch (type) {
            case KKLayout: {
                layout = new KKLayout(this.graph);
                break;
            }
            case FRLayout: {
                layout = new FRLayout(this.graph);
                break;
            }
            case ISOMLayout: {
                layout = new ISOMLayout(this.graph);
                break;
            }
            case SpringLayout: {
                layout = new SpringLayout(this.graph);
                break;
            }
            case CircleLayout: {
                layout = new CircleLayout(this.graph);
                break;
            }
            case FRLayout2: {
                layout = new FRLayout2(this.graph);
                break;
            }
            case SpringLayout2: {
                layout = new SpringLayout2(this.graph);
                break;
            }
        }
        if (this.graph.getVertexCount() < 100) {
            layout.setInitializer((Transformer)this.vv.getGraphLayout());
            layout.setSize(this.getSize());
            LayoutTransition lt = new LayoutTransition(this.vv, this.vv.getGraphLayout(), (Layout)layout);
            Animator animator = new Animator((IterativeContext)lt);
            animator.start();
            this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
            this.repaint(500L);
        } else {
            this.vv.setModel((VisualizationModel)new DefaultVisualizationModel((Layout)layout));
            this.repaint(500L);
        }
    }

    @Override
    public final void mouseClicked(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                JungGraphActions popup = null;
                popup = new JungGraphActions(this);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    public void refreshUI() {
        this.vv.getGraphLayout().setSize(this.getSize());
        this.vv.setModel((VisualizationModel)new DefaultVisualizationModel(this.vv.getGraphLayout()));
        this.repaint(500L);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public boolean isShowNodeLabels() {
        return this.showNodeLabels;
    }

    public void setShowNodeLabels(boolean showNodeLabels) {
        this.showNodeLabels = showNodeLabels;
        if (showNodeLabels) {
            this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        } else {
            this.vv.getRenderContext().setVertexLabelTransformer(this.emptyNodeLabelTransformer);
        }
        this.repaint(500L);
    }

    public boolean isShowEdgeLabels() {
        return this.showEdgeLabels;
    }

    public void setShowEdgeLabels(boolean showEdgeLabels) {
        this.showEdgeLabels = showEdgeLabels;
        if (showEdgeLabels) {
            this.vv.getRenderContext().setEdgeLabelTransformer((Transformer)new ToStringLabeller());
        } else {
            this.vv.getRenderContext().setEdgeLabelTransformer(this.emptyEdgeLabelTransformer);
        }
        this.repaint(500L);
    }

    public Graph<N, EdgeWrapper<E>> getGraph() {
        return this.graph;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.repaint(500L);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.vv.getGraphLayout().setSize(this.getSize());
        this.vv.setModel((VisualizationModel)new DefaultVisualizationModel(this.vv.getGraphLayout()));
        this.repaint(500L);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void graphClicked(N v, MouseEvent me) {
        long index = this.graphMatrix.getIndexOfNode(v);
        this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(index, index);
        this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(index, index);
    }

    public void graphPressed(N v, MouseEvent me) {
        long index = this.graphMatrix.getIndexOfNode(v);
        this.matrixGUIObject.getRowSelectionModel().setSelectionInterval(index, index);
        this.matrixGUIObject.getColumnSelectionModel().setSelectionInterval(index, index);
    }

    public void graphReleased(N v, MouseEvent me) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphLayout {
        CircleLayout,
        FRLayout,
        FRLayout2,
        ISOMLayout,
        KKLayout,
        SpringLayout,
        SpringLayout2;

    }
}

