/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.jscience;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javolution.util.FastTable;
import javolution.util.Index;
import org.jscience.mathematics.number.Float64;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DenseMatrix;
import org.jscience.mathematics.vector.Float64Matrix;
import org.jscience.mathematics.vector.Float64Vector;
import org.jscience.mathematics.vector.LUDecomposition;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.SparseMatrix;
import org.ujmp.core.doublematrix.stub.AbstractDenseDoubleMatrix2D;
import org.ujmp.core.interfaces.Wrapper;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.ReflectionUtil;
import org.ujmp.jscience.JScienceDenseDoubleMatrix2DFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JScienceDenseDoubleMatrix2D
extends AbstractDenseDoubleMatrix2D
implements Wrapper<Float64Matrix> {
    private static final long serialVersionUID = -7874694468839411484L;
    public static final JScienceDenseDoubleMatrix2DFactory Factory = new JScienceDenseDoubleMatrix2DFactory();
    private transient Float64Matrix matrix;
    private Boolean transposed = false;
    private transient FastTable<Float64Vector> rows = null;

    public JScienceDenseDoubleMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.matrix = Float64Matrix.valueOf((double[][])new double[rows][columns]);
    }

    public JScienceDenseDoubleMatrix2D(Float64Matrix matrix) {
        super((long)matrix.getNumberOfRows(), (long)matrix.getNumberOfColumns());
        this.matrix = matrix;
    }

    public JScienceDenseDoubleMatrix2D(double[][] values) {
        super((long)values.length, (long)values[0].length);
        this.matrix = Float64Matrix.valueOf((double[][])values);
    }

    public JScienceDenseDoubleMatrix2D(double[] values) {
        super((long)values.length, 1L);
        this.matrix = Float64Matrix.valueOf((Float64Vector[])new Float64Vector[]{Float64Vector.valueOf((double[])values)});
    }

    public JScienceDenseDoubleMatrix2D(org.ujmp.core.Matrix matrix) {
        super(matrix.getRowCount(), matrix.getColumnCount());
        this.matrix = Float64Matrix.valueOf((double[][])matrix.toDoubleArray());
        if (matrix.getMetaData() != null) {
            this.setMetaData(matrix.getMetaData().clone());
        }
    }

    public JScienceDenseDoubleMatrix2D(DenseMatrix<Float64> matrix) {
        super((long)matrix.getNumberOfRows(), (long)matrix.getNumberOfColumns());
        this.matrix = Float64Matrix.valueOf(matrix);
    }

    public JScienceDenseDoubleMatrix2D(SparseMatrix<Float64> matrix) {
        super((long)matrix.getNumberOfRows(), (long)matrix.getNumberOfColumns());
        this.matrix = Float64Matrix.valueOf(matrix);
    }

    @Override
    public double getDouble(long row, long column) {
        return this.matrix.get((int)row, (int)column).doubleValue();
    }

    @Override
    public double getDouble(int row, int column) {
        return this.matrix.get(row, column).doubleValue();
    }

    @Override
    public void setDouble(double value, long row, long column) {
        if (this.getTransposed()) {
            Float64Vector f = (Float64Vector)this.getRowsTable().get((int)column);
            double[] data = (double[])ReflectionUtil.extractPrivateField(f, "_values");
            data[(int)row] = value;
        } else {
            Float64Vector f = (Float64Vector)this.getRowsTable().get((int)row);
            double[] data = (double[])ReflectionUtil.extractPrivateField(f, "_values");
            data[(int)column] = value;
        }
    }

    private boolean getTransposed() {
        if (this.transposed == null) {
            this.transposed = (Boolean)ReflectionUtil.extractPrivateField(Float64Matrix.class, this.matrix, "_transposed");
        }
        return this.transposed;
    }

    private FastTable<Float64Vector> getRowsTable() {
        if (this.rows == null) {
            this.rows = (FastTable)ReflectionUtil.extractPrivateField(Float64Matrix.class, this.matrix, "_rows");
        }
        return this.rows;
    }

    @Override
    public void setDouble(double value, int row, int column) {
        if (this.getTransposed()) {
            Float64Vector f = (Float64Vector)this.getRowsTable().get(column);
            double[] data = (double[])ReflectionUtil.extractPrivateField(Float64Vector.class, f, "_values");
            data[row] = value;
        } else {
            Float64Vector f = (Float64Vector)this.getRowsTable().get(row);
            double[] data = (double[])ReflectionUtil.extractPrivateField(Float64Vector.class, f, "_values");
            data[column] = value;
        }
    }

    @Override
    public org.ujmp.core.Matrix mtimes(org.ujmp.core.Matrix that) {
        if (that instanceof JScienceDenseDoubleMatrix2D) {
            return new JScienceDenseDoubleMatrix2D(this.matrix.times((Matrix)((JScienceDenseDoubleMatrix2D)that).matrix));
        }
        return super.mtimes(that);
    }

    @Override
    public org.ujmp.core.Matrix plus(org.ujmp.core.Matrix that) {
        if (that instanceof JScienceDenseDoubleMatrix2D) {
            JScienceDenseDoubleMatrix2D result = new JScienceDenseDoubleMatrix2D(this.matrix.plus((Matrix)((JScienceDenseDoubleMatrix2D)that).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.plus(that);
    }

    @Override
    public org.ujmp.core.Matrix minus(org.ujmp.core.Matrix that) {
        if (that instanceof JScienceDenseDoubleMatrix2D) {
            JScienceDenseDoubleMatrix2D result = new JScienceDenseDoubleMatrix2D(this.matrix.minus((Matrix)((JScienceDenseDoubleMatrix2D)that).matrix));
            MapMatrix<String, Object> a = this.getMetaData();
            if (a != null) {
                result.setMetaData(a.clone());
            }
            return result;
        }
        return super.minus(that);
    }

    @Override
    public org.ujmp.core.Matrix times(double value) {
        JScienceDenseDoubleMatrix2D result = new JScienceDenseDoubleMatrix2D(this.matrix.times(Float64.valueOf((double)value)));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public org.ujmp.core.Matrix divide(double value) {
        JScienceDenseDoubleMatrix2D result = new JScienceDenseDoubleMatrix2D(this.matrix.times(Float64.valueOf((double)(1.0 / value))));
        MapMatrix<String, Object> a = this.getMetaData();
        if (a != null) {
            result.setMetaData(a.clone());
        }
        return result;
    }

    @Override
    public org.ujmp.core.Matrix transpose() {
        return new JScienceDenseDoubleMatrix2D(this.matrix.transpose().copy());
    }

    @Override
    public org.ujmp.core.Matrix inv() {
        return new JScienceDenseDoubleMatrix2D(this.matrix.inverse());
    }

    @Override
    public org.ujmp.core.Matrix[] lu() {
        if (this.isSquare()) {
            LUDecomposition lu = LUDecomposition.valueOf((Matrix)this.matrix);
            int m = (int)this.getRowCount();
            DenseMatrix lt = lu.getLower((Field)Float64.ZERO, (Field)Float64.ONE);
            DenseMatrix ut = lu.getUpper((Field)Float64.ZERO);
            FastTable piv = lu.getPivots();
            JScienceDenseDoubleMatrix2D l = new JScienceDenseDoubleMatrix2D((DenseMatrix<Float64>)lt);
            JScienceDenseDoubleMatrix2D u = new JScienceDenseDoubleMatrix2D((DenseMatrix<Float64>)ut);
            JScienceDenseDoubleMatrix2D p = new JScienceDenseDoubleMatrix2D(m, m);
            for (int i = 0; i < m; ++i) {
                p.setAsDouble(1.0, new long[]{i, ((Index)piv.get(i)).intValue()});
            }
            return new org.ujmp.core.Matrix[]{l, u, p};
        }
        throw new RuntimeException("matrix must be square");
    }

    @Override
    public Float64Matrix getWrappedObject() {
        return this.matrix;
    }

    public void setWrappedObject(Float64Matrix object) {
        this.matrix = object;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        double[][] values = (double[][])s.readObject();
        this.matrix = Float64Matrix.valueOf((double[][])values);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.toDoubleArray());
    }

    @Override
    public org.ujmp.core.Matrix solve(org.ujmp.core.Matrix b) {
        if (b instanceof JScienceDenseDoubleMatrix2D) {
            JScienceDenseDoubleMatrix2D b2 = (JScienceDenseDoubleMatrix2D)b;
            Float64Matrix x = Float64Matrix.valueOf((Matrix)this.matrix.solve((Matrix)b2.matrix));
            return new JScienceDenseDoubleMatrix2D(x);
        }
        return super.solve(b);
    }

    public JScienceDenseDoubleMatrix2DFactory getFactory() {
        return Factory;
    }
}

