/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.stringmatrix.impl;

import org.ujmp.core.Matrix;
import org.ujmp.core.interfaces.HasStringArray;
import org.ujmp.core.stringmatrix.stub.AbstractDenseStringMatrix2D;
import org.ujmp.core.util.MathUtil;

public class DefaultDenseStringMatrix2D
extends AbstractDenseStringMatrix2D
implements HasStringArray {
    private static final long serialVersionUID = 1643931435178952984L;
    private final String[] values;
    private final int rows;
    private final int cols;

    public DefaultDenseStringMatrix2D(Matrix m) {
        super(m.getRowCount(), m.getColumnCount());
        this.rows = MathUtil.longToInt(m.getRowCount());
        this.cols = MathUtil.longToInt(m.getColumnCount());
        if (m instanceof DefaultDenseStringMatrix2D) {
            String[] v = ((DefaultDenseStringMatrix2D)m).values;
            this.values = new String[v.length];
            System.arraycopy(v, 0, this.values, 0, v.length);
        } else {
            this.values = new String[this.rows * this.cols];
            for (long[] c : m.allCoordinates()) {
                this.setString(m.getAsString(c), c);
            }
        }
        if (m.getMetaData() != null) {
            this.setMetaData(m.getMetaData().clone());
        }
    }

    public DefaultDenseStringMatrix2D(int rows, int columns) {
        super((long)rows, (long)columns);
        this.rows = rows;
        this.cols = columns;
        this.values = new String[rows * columns];
    }

    public DefaultDenseStringMatrix2D(String[] v, int rows, int cols) {
        super((long)rows, (long)cols);
        this.rows = rows;
        this.cols = cols;
        this.values = v;
    }

    public String getString(long row, long column) {
        return this.values[(int)(column * (long)this.rows + row)];
    }

    public void setString(String value, long row, long column) {
        this.values[(int)(column * (long)this.rows + row)] = value;
    }

    public String getString(int row, int column) {
        return this.values[column * this.rows + row];
    }

    public void setString(String value, int row, int column) {
        this.values[column * this.rows + row] = value;
    }

    public final Matrix copy() {
        String[] result = new String[this.values.length];
        System.arraycopy(this.values, 0, result, 0, this.values.length);
        DefaultDenseStringMatrix2D m = new DefaultDenseStringMatrix2D(result, this.rows, this.cols);
        if (this.getMetaData() != null) {
            m.setMetaData(this.getMetaData().clone());
        }
        return m;
    }

    public final Matrix transpose() {
        String[] result = new String[this.cols * this.rows];
        int c = this.rows;
        while (--c != -1) {
            int r = this.cols;
            while (--r != -1) {
                result[c * this.cols + r] = this.values[r * this.rows + c];
            }
        }
        return new DefaultDenseStringMatrix2D(result, this.cols, this.rows);
    }

    public String[] getStringArray() {
        return this.values;
    }
}

