/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.core.calculation;

import java.math.BigDecimal;
import org.ujmp.core.DenseMatrix;
import org.ujmp.core.DenseMatrix2D;
import org.ujmp.core.Matrix;
import org.ujmp.core.calculation.MinusScalar;
import org.ujmp.core.calculation.MinusScalarCalculation;
import org.ujmp.core.mapmatrix.MapMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.core.util.UJMPSettings;
import org.ujmp.core.util.VerifyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MinusScalarDenseMatrix
implements MinusScalarCalculation<DenseMatrix, DenseMatrix> {
    MinusScalarDenseMatrix() {
    }

    @Override
    public final void calc(DenseMatrix source, BigDecimal value, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            MinusScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
        } else {
            MapMatrix<String, Object> a;
            VerifyUtil.verifySameSize((Matrix)source, (Matrix)target);
            for (long[] c : source.allCoordinates()) {
                BigDecimal svalue = source.getAsBigDecimal(c);
                BigDecimal result = MathUtil.minus(svalue, value);
                target.setAsBigDecimal(result, c);
            }
            if (source != target && (a = source.getMetaData()) != null) {
                target.setMetaData(a.clone());
            }
        }
    }

    @Override
    public final void calc(DenseMatrix source, double value, DenseMatrix target) {
        if (source instanceof DenseMatrix2D && target instanceof DenseMatrix2D) {
            MinusScalar.DENSEMATRIX2D.calc((DenseMatrix2D)source, value, (DenseMatrix2D)target);
        } else {
            this.calc(source, new BigDecimal(value, UJMPSettings.getInstance().getMathContext()), target);
        }
    }
}

