/*
 * Decompiled with CFR 0.152.
 */
package org.ujmp.complete.benchmark;

import java.util.LinkedList;
import java.util.Random;
import org.ujmp.core.Matrix;
import org.ujmp.core.doublematrix.impl.DenseFileMatrix;
import org.ujmp.core.genericmatrix.stub.AbstractGenericMatrix;
import org.ujmp.core.interfaces.Erasable;
import org.ujmp.core.objectmatrix.impl.SerializedSparseObjectMatrix;
import org.ujmp.core.util.MathUtil;
import org.ujmp.ehcache.EhcacheSparseObjectMatrix;
import org.ujmp.jdbc.matrix.JDBCSparseObjectMatrix;
import org.ujmp.lucene.LuceneSparseObjectMatrix;

public class VeryLargeMatrixBenchmark {
    public static final int MATRIXSIZE = 10000;
    public static final int MAXTIME = 30;
    public static final int BURNINTIME = 10;
    public static final int MAXENTRYCOUNT = 100000;

    public static void main(String[] args) throws Exception {
        System.out.println("Disk Matrix Benchmark");
        System.out.println("=====================");
        System.out.println("This benchmark creates a very large matrix on disk");
        System.out.println("and measures the time for reading and writing data");
        System.out.println();
        System.out.println("Matrix size: 10000x10000");
        System.out.println("Main Memory: " + Runtime.getRuntime().maxMemory() / 1000000L + "M");
        System.out.println();
        LinkedList<AbstractGenericMatrix> matricesToTest = new LinkedList<AbstractGenericMatrix>();
        matricesToTest.add(new DenseFileMatrix(10000L, 10000L));
        matricesToTest.add(new SerializedSparseObjectMatrix(10000L, 10000L));
        matricesToTest.add(new LuceneSparseObjectMatrix(10000L, 10000L));
        matricesToTest.add(new JDBCSparseObjectMatrix(10000L, 10000L));
        matricesToTest.add(new EhcacheSparseObjectMatrix(10000L, 10000L));
        for (Matrix matrix : matricesToTest) {
            System.out.println(matrix.getClass().getSimpleName());
            VeryLargeMatrixBenchmark.runPerformanceTest(matrix);
            if (!(matrix instanceof Erasable)) continue;
            ((Erasable)((Object)matrix)).erase();
        }
    }

    private static void runPerformanceTest(Matrix m) throws Exception {
        double v;
        long r;
        double v2;
        int col;
        int row;
        int writtenEntryCount;
        long t;
        long seed = t = System.currentTimeMillis();
        Random random = new Random();
        while (System.currentTimeMillis() - t < 10000L) {
            double value = MathUtil.nextDouble();
            m.setAsObject(value, random.nextInt(10000), random.nextInt(10000));
        }
        t = System.currentTimeMillis();
        random = new Random(seed);
        for (writtenEntryCount = 0; System.currentTimeMillis() - t < 30000L && writtenEntryCount < 100000; ++writtenEntryCount) {
            double value = MathUtil.nextDouble();
            m.setAsObject(value, random.nextInt(10000), random.nextInt(10000));
        }
        System.out.println(" Writing random entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, writtenEntryCount, -1);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(random.nextInt(10000), random.nextInt(10000));
        }
        random = new Random();
        t = System.currentTimeMillis();
        int readEntryCount = 0;
        int hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v2 = m.getAsDouble(row, col);
            ++readEntryCount;
            if (v2 == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading random entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(random.nextInt(10000), random.nextInt(10000));
        }
        random = new Random();
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L && readEntryCount < 100000) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v2 = m.getAsDouble(row, col);
            m.setAsDouble(v2 + 1.0, row, col);
            ++readEntryCount;
            if (v2 == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading/writing random entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        random = new Random(seed);
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L && readEntryCount < writtenEntryCount) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v2 = m.getAsDouble(row, col);
            ++readEntryCount;
            if (v2 == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading random non-zero entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(random.nextInt(10000), random.nextInt(10000));
        }
        t = System.currentTimeMillis();
        random = new Random(seed);
        readEntryCount = 0;
        hitCount = 0;
        while (System.currentTimeMillis() - t < 30000L && readEntryCount < writtenEntryCount) {
            row = random.nextInt(10000);
            col = random.nextInt(10000);
            v2 = m.getAsDouble(row, col);
            m.setAsDouble(v2 + 1.0, row, col);
            ++readEntryCount;
            if (v2 == 0.0) continue;
            ++hitCount;
        }
        System.out.println(" Reading/writing random non-zero entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        if (m instanceof LuceneSparseObjectMatrix) {
            System.out.println();
            return;
        }
        while (System.currentTimeMillis() - t < 10000L) {
            double value = MathUtil.nextDouble();
            m.setAsObject(value, random.nextInt(10000), random.nextInt(10000));
        }
        t = System.currentTimeMillis();
        writtenEntryCount = 0;
        block10: for (r = 0L; r < m.getRowCount(); ++r) {
            long c = 0L;
            while (r < m.getColumnCount()) {
                double value = MathUtil.nextDouble();
                m.setAsObject(value, r, c++);
                if (System.currentTimeMillis() - t > 30000L || ++writtenEntryCount > 100000) continue block10;
            }
        }
        System.out.println(" Writing consecutive entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, writtenEntryCount, -1);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(random.nextInt(10000), random.nextInt(10000));
        }
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        block13: for (r = 0L; r < m.getRowCount(); ++r) {
            long c = 0L;
            while (r < m.getColumnCount()) {
                v = m.getAsDouble(r, c);
                ++readEntryCount;
                if (v != 0.0) {
                    ++hitCount;
                }
                if (System.currentTimeMillis() - t > 30000L || readEntryCount > writtenEntryCount) continue block13;
                ++c;
            }
        }
        System.out.println(" Reading consecutive entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        t = System.currentTimeMillis();
        while (System.currentTimeMillis() - t < 10000L) {
            m.getAsDouble(random.nextInt(10000), random.nextInt(10000));
        }
        t = System.currentTimeMillis();
        readEntryCount = 0;
        hitCount = 0;
        block16: for (r = 0L; r < m.getRowCount(); ++r) {
            long c = 0L;
            while (r < m.getColumnCount()) {
                v = m.getAsDouble(r, c);
                m.setAsDouble(v + 1.0, r, c);
                ++readEntryCount;
                if (v != 0.0) {
                    ++hitCount;
                }
                if (System.currentTimeMillis() - t > 30000L || readEntryCount > writtenEntryCount) continue block16;
                ++c;
            }
        }
        System.out.println(" Reading/writing consecutive entries");
        VeryLargeMatrixBenchmark.printStatistics(System.currentTimeMillis() - t, readEntryCount, hitCount);
        System.out.println();
    }

    private static void printStatistics(long time, int count, int hits) {
        double speed = (double)count / (double)time * 1000.0;
        double throughput = speed * 8.0 / 1000.0;
        System.out.println("  time: " + time / 1000L + "s");
        if (hits >= 0) {
            System.out.println("  count: " + hits + " hits of " + count);
        } else {
            System.out.println("  count: " + count);
        }
        System.out.println("  speed: " + speed + " entries/s");
        System.out.println("  throughput: " + throughput + " KB/s");
    }
}

