/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import boone.Boone;
import boone.io.Storable;
import boone.util.Common;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class Xml {
    public static Document buildDocument() {
        return new Document();
    }

    public static Document buildDocument(String string) {
        File file = new File(string);
        return Xml.buildDocument(file);
    }

    public static Document buildDocument(File file) {
        Document document = null;
        if (file.exists()) {
            try {
                SAXBuilder sAXBuilder = new SAXBuilder();
                document = sAXBuilder.build(file);
            }
            catch (IOException | JDOMException throwable) {
                throwable.printStackTrace();
            }
        }
        if (document == null) {
            document = new Document();
        }
        return document;
    }

    public static Document buildDocument(InputStream inputStream) {
        Document document = null;
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            document = sAXBuilder.build(inputStream);
            inputStream.close();
        }
        catch (IOException | JDOMException throwable) {
            throwable.printStackTrace();
        }
        if (document == null) {
            document = new Document();
        }
        return document;
    }

    public static Element addChildTo(Element element, String string, String string2) {
        Element element2 = new Element(string);
        element2.setText(string2);
        element.addContent((Content)element2);
        return element2;
    }

    public static Element getChildOf(Element element, String string) {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            element2 = new Element(string);
            element.addContent((Content)element2);
        }
        return element2;
    }

    public static String getNodeContent(Element element, String string) {
        if (element == null) {
            return null;
        }
        Element element2 = element.getChild(string);
        if (element2 != null) {
            return element2.getText();
        }
        return element.getAttributeValue(string);
    }

    public static void saveDocument(Document document, OutputStream outputStream) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter();
        xMLOutputter.setFormat(Format.getPrettyFormat());
        xMLOutputter.output(document, outputStream);
        outputStream.close();
    }

    public static String getProperty(Element element, String string, String string2) {
        String string3 = Xml.getNodeContent(element, string);
        if (string3 == null || string3.equals("")) {
            return string2;
        }
        return string3;
    }

    public static int getProperty(Element element, String string, int n) {
        int n2;
        String string2 = Xml.getNodeContent(element, string);
        if (string2 == null) {
            n2 = n;
        } else {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
        }
        return n2;
    }

    public static long getProperty(Element element, String string, long l) {
        long l2;
        String string2 = Xml.getNodeContent(element, string);
        if (string2 == null) {
            l2 = l;
        } else {
            try {
                l2 = Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                l2 = l;
            }
        }
        return l2;
    }

    public static int getDualProperty(Element element, String string, String string2, int n) {
        if (Xml.hasAttributeValue(element, string)) {
            return Xml.getProperty(element, string, n);
        }
        if (Xml.hasAttributeValue(element, string2)) {
            return Xml.getProperty(element, string2, n);
        }
        return n;
    }

    public static long getDualProperty(Element element, String string, String string2, long l) {
        if (Xml.hasAttributeValue(element, string)) {
            return Xml.getProperty(element, string, l);
        }
        if (Xml.hasAttributeValue(element, string2)) {
            return Xml.getProperty(element, string2, l);
        }
        return l;
    }

    public static double getProperty(Element element, String string, double d) {
        double d2;
        String string2 = Xml.getNodeContent(element, string);
        if (string2 == null) {
            d2 = d;
        } else {
            try {
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                d2 = d;
            }
        }
        return d2;
    }

    public static double getDualProperty(Element element, String string, String string2, double d) {
        if (Xml.hasAttributeValue(element, string)) {
            return Xml.getProperty(element, string, d);
        }
        if (Xml.hasAttributeValue(element, string2)) {
            return Xml.getProperty(element, string2, d);
        }
        return d;
    }

    public static float getProperty(Element element, String string, float f) {
        float f2;
        String string2 = Xml.getNodeContent(element, string);
        if (string2 == null) {
            f2 = f;
        } else {
            try {
                f2 = Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                f2 = f;
            }
        }
        return f2;
    }

    public static boolean getProperty(Element element, String string, boolean bl) {
        String string2 = Xml.getNodeContent(element, string);
        boolean bl2 = string2 == null ? bl : Boolean.parseBoolean(string2);
        return bl2;
    }

    public static boolean getDualProperty(Element element, String string, String string2, boolean bl) {
        if (Xml.hasAttributeValue(element, string)) {
            return Xml.getProperty(element, string, bl);
        }
        if (Xml.hasAttributeValue(element, string2)) {
            return Xml.getProperty(element, string2, bl);
        }
        return bl;
    }

    public static boolean hasAttributeValue(Element element, String string) {
        return element.getAttribute(string) != null;
    }

    public static Storable getStorable(Element element, String string) {
        Element element2 = element.getChild(string);
        if (element2 == null) {
            return null;
        }
        return Xml.getStorable(element2);
    }

    public static Storable getStorable(Element element) {
        String string = Xml.getProperty(element, "class", null);
        if (string == null) {
            return null;
        }
        Storable storable = (Storable)Boone.newInstance(string);
        if (storable != null) {
            storable.fromXML(element);
        }
        return storable;
    }

    public static Element addStorable(Element element, String string, Storable storable) {
        Element element2 = Xml.addChildTo(element, string, null);
        Xml.addClassName(element2, storable);
        return element2;
    }

    public static void addClassName(Element element, Object object) {
        String string = object.getClass().getName();
        string = Common.cutHeadAtLast(string, '.');
        string = Common.cutHeadAtLast(string, '$');
        element.setAttribute("class", string);
    }
}

