/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import boone.NeuralNet;
import boone.Neuron;
import boone.PatternSet;
import boone.map.HexagonTopology;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;

public class UMatrix {
    protected PatternSet patterns;
    protected HexagonTopology topology;
    private int scale;
    protected File pngFile;
    protected HashMap<String, Color> colors = new HashMap();
    private int strokeWidth;
    protected BufferedImage som;
    private Graphics2D graphics;
    private Font smallFont;
    private Font bigFont;
    private boolean showNames;

    public UMatrix(PatternSet patternSet, HexagonTopology hexagonTopology, int n, File file) {
        this.patterns = patternSet;
        this.topology = hexagonTopology;
        this.scale = n;
        this.pngFile = file;
        this.colors.put("", Color.decode("#cccccc"));
        Color[] colorArray = new Color[]{Color.red, Color.blue, Color.cyan, Color.magenta, Color.green, Color.orange, Color.decode("#22aa44"), Color.black, Color.gray};
        for (int i = 0; i < patternSet.getTargetLabelCount(); ++i) {
            this.colors.put(patternSet.getTargetLabel(i), colorArray[i]);
        }
        double[] dArray = hexagonTopology.getSizes();
        int n2 = (int)(dArray[0] * (double)this.scale);
        int n3 = (int)(dArray[1] * (double)this.scale);
        this.strokeWidth = (int)(0.0244 * (double)this.scale);
        int[] nArray = hexagonTopology.getNeurons();
        int n4 = n2 / nArray[0] + 1;
        n4 = n4 / 4 + 4 * this.strokeWidth;
        int n5 = n3 / nArray[1] + 1;
        n5 = n5 / 4 + 4 * this.strokeWidth;
        this.som = new BufferedImage(n2 += 2 * n4, n3 += 2 * n5, 2);
        this.graphics = this.som.createGraphics();
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.translate(n4, n5);
        this.graphics.setBackground(Color.white);
        this.graphics.setPaint(Color.white);
        this.graphics.fillRect(-n4, -n5, n2, n3);
        this.graphics.setPaint(Color.black);
        this.bigFont = new Font("TimesRoman", 0, (int)(0.13 * (double)this.scale));
        this.smallFont = new Font("TimesRoman", 0, (int)(0.1 * (double)this.scale));
        this.graphics.setFont(this.bigFont);
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public void setShowNames(boolean bl) {
        this.showNames = bl;
    }

    public void visualize() {
        Serializable serializable;
        Neuron neuron;
        int n;
        double d;
        NeuralNet neuralNet = this.topology.getNet();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_NORMAL;
        for (int i = 0; i < neuralNet.getOutputNeuronCount(); ++i) {
            for (int j = i + 1; j < neuralNet.getOutputNeuronCount(); ++j) {
                d = this.calculateWeightDistance(neuralNet.getOutputNeuron(i), neuralNet.getOutputNeuron(j));
                if (d > d3) {
                    d3 = d;
                }
                if (!(d < d2)) continue;
                d2 = d;
            }
        }
        double d4 = 0.0;
        for (n = 0; n < neuralNet.getOutputNeuronCount(); ++n) {
            neuron = neuralNet.getOutputNeuron(n);
            serializable = new ArrayList<Neuron>(3);
            serializable.add(this.topology.getRight(n));
            serializable.add(this.topology.getLowerLeft(n));
            serializable.add(this.topology.getLowerRight(n));
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                int n2;
                Neuron neuron2 = (Neuron)iterator.next();
                if (neuron2 == null) continue;
                double d5 = neuron.getPosition().getXPos() + (neuron2.getPosition().getXPos() - neuron.getPosition().getXPos()) / 2.0f;
                d = neuron.getPosition().getYPos() + (neuron2.getPosition().getYPos() - neuron.getPosition().getYPos()) / 2.0f;
                d4 = neuron.getPosition().distanceTo(neuron2.getPosition()) / (2.0 * Math.sqrt(3.0));
                d5 *= (double)this.scale;
                d *= (double)this.scale;
                d4 *= (double)this.scale;
                double d6 = this.calculateWeightDistance(neuron, neuron2);
                Polygon polygon = new Polygon();
                for (n2 = 0; n2 < 6; ++n2) {
                    polygon.addPoint((int)(d5 + d4 * Math.cos(((double)n2 + 0.5) * 2.0 * Math.PI / 6.0)), (int)(d + d4 * Math.sin(((double)n2 + 0.5) * 2.0 * Math.PI / 6.0)));
                }
                n2 = 255 - (int)((d6 - d2) / (d3 - d2) * 255.0);
                String string = Integer.toHexString(n2);
                if (string.length() < 2) {
                    string = "0" + string;
                }
                this.graphics.setColor(Color.decode("#" + string + string + string));
                this.graphics.fillPolygon(polygon);
            }
        }
        for (n = 0; n < neuralNet.getOutputNeuronCount(); ++n) {
            neuron = neuralNet.getOutputNeuron(n);
            double d7 = neuron.getPosition().getXPos();
            d = neuron.getPosition().getYPos();
            d7 *= (double)this.scale;
            d *= (double)this.scale;
            serializable = new Polygon();
            for (int i = 0; i < 6; ++i) {
                ((Polygon)serializable).addPoint((int)(d7 + d4 * Math.cos(((double)i + 0.5) * 2.0 * Math.PI / 6.0)), (int)(d + d4 * Math.sin(((double)i + 0.5) * 2.0 * Math.PI / 6.0)));
            }
            this.graphics.setColor(this.colors.get(neuron.getName()));
            this.graphics.setStroke(new BasicStroke(this.strokeWidth));
            this.graphics.drawPolygon((Polygon)serializable);
            this.graphics.drawString((neuron.getName() + "    ").substring(0, 4), (float)(d7 - 0.122 * (double)this.scale), (float)(d - 0.0732 * (double)this.scale));
        }
        if (this.showNames) {
            this.drawNames();
        } else {
            this.drawHits();
        }
        try {
            ImageIO.write((RenderedImage)this.som, "PNG", this.pngFile);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private double calculateWeightDistance(Neuron neuron, Neuron neuron2) {
        NeuralNet neuralNet = this.topology.getNet();
        double d = 0.0;
        for (int i = 0; i < neuralNet.getInputNeuronCount(); ++i) {
            double d2 = neuralNet.getInputNeuron(i).getLinkTo(neuron).getWeight();
            double d3 = neuralNet.getInputNeuron(i).getLinkTo(neuron2).getWeight();
            double d4 = d2 - d3;
            d += d4 * d4;
        }
        return Math.sqrt(d);
    }

    private void drawNames() {
        NeuralNet neuralNet = this.topology.getNet();
        int[] nArray = new int[neuralNet.getOutputNeuronCount()];
        for (int i = 0; i < this.patterns.size(); ++i) {
            Neuron neuron = neuralNet.getTrainer().getWinningNeuron(this.patterns.getInputs().get(i));
            String string = this.patterns.getNames().get(i);
            string = (string + "     ").substring(0, 5);
            this.graphics.setFont(this.bigFont);
            int n = (int)neuron.getID();
            int n2 = nArray[n] + 1;
            nArray[n] = n2;
            this.drawLine(this.graphics, string, (float)(((double)neuron.getPosition().getXPos() - 0.0488) * (double)this.scale), (float)(((double)neuron.getPosition().getYPos() - 0.0732) * (double)this.scale), n2);
        }
    }

    private void drawHits() {
        Neuron neuron;
        int n;
        NeuralNet neuralNet = this.topology.getNet();
        int[] nArray = new int[neuralNet.getOutputNeuronCount()];
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < this.patterns.size(); ++n) {
            neuron = neuralNet.getTrainer().getWinningNeuron(this.patterns.getInputs().get(n));
            int n2 = (int)neuron.getID();
            nArray[n2] = nArray[n2] + 1;
            if (!this.patterns.getTargetLabelOfPattern(n).equals(neuron.getName())) continue;
            int n3 = (int)neuron.getID();
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n = 0; n < nArray.length; ++n) {
            neuron = neuralNet.getOutputNeuron(n);
            String string = nArray2[n] + "/" + nArray[n];
            this.graphics.setFont(this.smallFont);
            this.drawLine(this.graphics, string, (float)(((double)neuron.getPosition().getXPos() - 0.0488) * (double)this.scale), (float)(((double)neuron.getPosition().getYPos() - 0.0732) * (double)this.scale), 1);
        }
    }

    private void drawLine(Graphics2D graphics2D, String string, float f, float f2, int n) {
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        graphics2D.setColor(new Color(1.0f, 1.0f, 1.0f, 0.3f));
        graphics2D.fillRect((int)f, (int)((f2 += (float)(--n * fontMetrics.getHeight())) + (float)(fontMetrics.getAscent() / 3)), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        graphics2D.setColor(Color.black);
        graphics2D.drawString(string, (int)f, (int)(f2 += (float)fontMetrics.getHeight()));
    }
}

