/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamParser {
    public BufferedInputStream stream;
    protected Exception readException;
    public int readState;
    public char curChar;
    public StringBuffer workBuffer = new StringBuffer();
    public String commentStart = "#";
    public char firstCommentChar = (char)35;

    public StreamParser(InputStream inputStream) {
        this.stream = new BufferedInputStream(inputStream);
        this.nextChar();
    }

    public void nextChar() {
        try {
            this.readState = this.stream.read();
            if (this.readState >= 0) {
                this.curChar = (char)this.readState;
            }
        }
        catch (Exception exception) {
            if (this.readException == null) {
                this.readException = exception;
            }
            this.readState = -2;
        }
    }

    public Exception getReadException() {
        Exception exception = this.readException;
        this.readException = null;
        return exception;
    }

    public void trimEnd(StringBuffer stringBuffer) {
        int n;
        for (n = stringBuffer.length() - 1; n >= 0 && stringBuffer.charAt(n) <= ' '; --n) {
        }
        stringBuffer.setLength(n + 1);
    }

    public void readSpaceOnly() {
        while (this.curChar <= ' ' && this.readState >= 0) {
            this.nextChar();
        }
    }

    public void readSpace() {
        while ((this.curChar <= ' ' || this.curChar == this.firstCommentChar) && this.readState >= 0) {
            if (this.curChar == this.firstCommentChar) {
                this.stream.mark(this.commentStart.length() + 1);
                if (this.expect(this.commentStart)) {
                    while (this.curChar != '\n' && this.readState >= 0) {
                        this.nextChar();
                    }
                    continue;
                }
                try {
                    this.stream.reset();
                }
                catch (IOException iOException) {
                    this.readException = iOException;
                    this.readState = -2;
                }
                this.curChar = this.commentStart.charAt(0);
                return;
            }
            this.nextChar();
        }
    }

    public boolean expect(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (this.curChar != string.charAt(i) || this.readState < 0) {
                return false;
            }
            this.nextChar();
        }
        return true;
    }

    public void readWord() {
        this.workBuffer.setLength(0);
        while (this.curChar > ' ' && this.readState >= 0) {
            this.workBuffer.append(this.curChar);
            this.nextChar();
        }
    }

    public void readLine() {
        this.workBuffer.setLength(0);
        while (this.curChar != '\n' && this.readState >= 0) {
            if (this.curChar != '\r') {
                this.workBuffer.append(this.curChar);
            }
            this.nextChar();
        }
        if (this.readState >= 0) {
            this.nextChar();
        }
        if (this.readState >= 0 && this.curChar == '\r') {
            this.nextChar();
        }
    }

    public void readUntil(char c) {
        this.workBuffer.setLength(0);
        while (this.curChar != c && this.readState >= 0) {
            this.workBuffer.append(this.curChar);
            this.nextChar();
        }
    }

    public boolean readUntilCharOrNewline(char c) {
        this.workBuffer.setLength(0);
        while (this.curChar != c && this.curChar != '\n' && this.readState >= 0) {
            if (this.curChar != '\r') {
                this.workBuffer.append(this.curChar);
            }
            this.nextChar();
        }
        return this.curChar == c;
    }

    public int readIntNumber() {
        this.workBuffer.setLength(0);
        while ("0123456789-".indexOf(this.curChar) >= 0 && this.readState >= 0) {
            this.workBuffer.append(this.curChar);
            this.nextChar();
        }
        return Integer.parseInt(this.workBuffer.toString());
    }

    public double readFloatNumber() {
        this.workBuffer.setLength(0);
        while ("0123456789-.Ee".indexOf(this.curChar) >= 0 && this.readState >= 0) {
            this.workBuffer.append(this.curChar);
            this.nextChar();
        }
        return Double.parseDouble(this.workBuffer.toString());
    }
}

