/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import boone.map.Function;

public class RootSolver {
    private double precision_ = 1.0E-5;

    public double findRoot(Function function, double d, double d2) {
        double d3;
        double d4 = d3 = 0.001;
        double d5 = d;
        double d6 = d5 + d3;
        double d7 = function.map(d5);
        double d8 = function.map(d6);
        double d9 = function.mapDerivative(d6);
        while (d6 <= d2) {
            double d10;
            if (this.sign(d7) != this.sign(d8) && !Double.isNaN(d10 = this.bisection(d5, d6, function)) && Math.abs(d - d10) > this.precision_ && function.mapDerivative(d10) >= 0.0) {
                return d10;
            }
            d5 = d6;
            d7 = d8;
            d8 = function.map(d6 += d4);
            d9 = function.mapDerivative(d5);
            if (Math.abs(d8) > 10.0 && Math.abs(d8 + d4 * d9) > 5.0) {
                d4 = d4 > 0.25 ? d4 : d4 * 1.1;
                continue;
            }
            if (Math.abs(d8) > 5.0 && Math.abs(d8 + d4 * d9) > 5.0) {
                d4 = d4 > 0.15 ? d4 : d4 * 1.1;
                continue;
            }
            if (Math.abs(d8) < 2.0 && d9 >= 0.0) {
                d4 = d4 < d3 ? d3 : d4 * 0.9;
                continue;
            }
            if (Math.abs(d8) < 2.0 && d9 < 0.0) {
                d4 = d4 > 0.1 ? d4 : d4 * 1.1;
                continue;
            }
            if (!(Math.abs(d8) <= 1.0)) continue;
            d4 = d3;
        }
        return Double.NaN;
    }

    public double calcLimit(Function function, int n, double d) {
        double d2 = 0.0;
        if (n == 0) {
            double d3 = this.fastRootAlgorithm(function, 0.0);
            double d4 = this.fastRootAlgorithm(new Function.Scaled(-1.0, -d, function), d3);
            return Double.isNaN(d4) ? d3 : d4;
        }
        if (n == 1) {
            double d5 = function.mapDerivative(0.0);
            if (d5 > 0.0) {
                d2 = this.fastRootAlgorithm(new Function.Scaled(1.0, -d, function), 0.0);
            }
            if (d5 < 0.0) {
                d2 = this.fastRootAlgorithm(new Function.Scaled(-1.0, -d, function), 0.0);
            }
        } else {
            throw new Function.NotImplemented("Unknown function type");
        }
        return d2;
    }

    private double fastRootAlgorithm(Function function, double d) {
        double d2 = d;
        double d3 = 0.01;
        double d4 = d + d3;
        while (Double.MAX_VALUE - d2 - d3 >= 0.0) {
            if (function.map(d4) == 0.0 && function.mapDerivative(d4) == 0.0) {
                return this.modifiedBisection(d2, d4, function);
            }
            if (function.map(d2) >= 0.0 && function.map(d4) <= 0.0) {
                return this.bisection(d2, d4, function);
            }
            if (function.map(d2) < 0.0 && function.map(d4) < 0.0 && function.mapDerivative(d4) < 0.0) {
                return this.handleSpecialCase(function, d2, d4);
            }
            d2 = d4;
            d4 += (d3 *= 2.0);
        }
        return Double.NaN;
    }

    private double handleSpecialCase(Function function, double d, double d2) {
        double d3 = d;
        double d4 = d2;
        double d5 = Double.NaN;
        boolean bl = false;
        while (!bl) {
            double d6 = (d + d4) / 2.0;
            double d7 = function.mapDerivative(d6);
            if (function.map(d6) < 0.0) {
                if (d7 < 0.0) {
                    d4 = d6;
                    continue;
                }
                d3 = d6;
                continue;
            }
            if (function.map(d6) > 0.0) {
                d5 = this.bisection(d3, d4, function);
                bl = true;
                continue;
            }
            if (function.map(d6) != 0.0 || !(d7 < 0.0)) continue;
            d5 = d6;
            bl = true;
        }
        return d5;
    }

    private double bisection(double d, double d2, Function function) {
        double d3 = d;
        double d4 = d2;
        for (int i = 100; i > 0; --i) {
            double d5 = (d3 + d4) / 2.0;
            if (Math.abs(function.map(d5)) < this.precision_) {
                return d5;
            }
            if (this.sign(function.map(d5)) == this.sign(function.map(d3))) {
                d3 = d5;
                continue;
            }
            d4 = d5;
        }
        return Double.NaN;
    }

    private double modifiedBisection(double d, double d2, Function function) {
        double d3 = d;
        double d4 = d2;
        for (int i = 250; i > 0; --i) {
            double d5 = (d3 + d4) / 2.0;
            if (function.map(d5) == 0.0) {
                d4 = d5;
                continue;
            }
            d3 = d5;
        }
        return d4;
    }

    private int sign(double d) {
        if (d < 0.0) {
            return -1;
        }
        return 1;
    }
}

