/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import boone.PatternSet;
import boone.util.Common;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Set;

public class Patterns {
    public static void join(PatternSet patternSet, PatternSet patternSet2) {
        patternSet.getNames().addAll(patternSet2.getNames());
        patternSet.getInputs().addAll(patternSet2.getInputs());
        patternSet.getTargets().addAll(patternSet2.getTargets());
        patternSet.getOutputs().addAll(patternSet2.getOutputs());
        Set<String> set = patternSet2.getProperties().stringPropertyNames();
        Properties properties = patternSet.getProperties();
        for (String string : set) {
            if (properties.containsKey(string)) continue;
            properties.setProperty(string, patternSet2.getProperties().getProperty(string));
        }
    }

    public static PatternSet getSubSet(PatternSet patternSet, int n, int n2) {
        if (patternSet.getInputs().size() < n2) {
            return null;
        }
        PatternSet patternSet2 = new PatternSet();
        if (patternSet.getNames().size() >= n2) {
            patternSet2.getNames().addAll(patternSet.getNames().subList(n, n2));
        }
        if (patternSet.getTargets().size() >= n2) {
            patternSet2.getTargets().addAll(patternSet.getTargets().subList(n, n2));
        }
        if (patternSet.getOutputs().size() >= n2) {
            patternSet2.getOutputs().addAll(patternSet.getOutputs().subList(n, n2));
        }
        patternSet2.getInputs().addAll(patternSet.getInputs().subList(n, n2));
        patternSet2.setProperties(new Properties(patternSet.getProperties()));
        return patternSet2;
    }

    public static void shuffle(PatternSet patternSet, int n) {
        Random random = Common.getRandom();
        int n2 = patternSet.size();
        for (int i = 0; i < n - 2; ++i) {
            int n3 = random.nextInt(n2 - i - 1) + i + 1;
            Patterns.swap(patternSet, i, n3);
        }
    }

    public static void swap(PatternSet patternSet, int n, int n2) {
        List<Double> list;
        if (n == n2) {
            return;
        }
        int n3 = Math.max(n, n2);
        if (patternSet.getNames().size() > n3) {
            list = patternSet.getNames().get(n);
            list = patternSet.getNames().set(n2, (String)((Object)list));
            patternSet.getNames().set(n, (String)((Object)list));
        }
        if (patternSet.getInputs().size() > n3) {
            list = patternSet.getInputs().get(n);
            list = patternSet.getInputs().set(n2, list);
            patternSet.getInputs().set(n, list);
        }
        if (patternSet.getTargets().size() > n3) {
            list = patternSet.getTargets().get(n);
            list = patternSet.getTargets().set(n2, list);
            patternSet.getTargets().set(n, list);
        }
        if (patternSet.getOutputs().size() > n3) {
            list = patternSet.getOutputs().get(n);
            list = patternSet.getOutputs().set(n2, list);
            patternSet.getOutputs().set(n, list);
        }
    }

    public static void normalizeInputs(PatternSet patternSet) {
        Patterns.normalizePatterns(patternSet.getInputs());
    }

    private static void normalizePatterns(List<List<Double>> list) {
        for (List<Double> list2 : list) {
            if (list2 == null) continue;
            double d = 0.0;
            for (double d2 : list2) {
                d += d2 * d2;
            }
            d = Math.sqrt(d);
            int n = list2.size();
            for (int i = 0; i < n; ++i) {
                double d3 = list2.get(i);
                list2.set(i, d3 / d);
            }
        }
    }

    public static void mapToInterval(PatternSet patternSet, double d, double d2, double d3, double d4) {
        Patterns.mapToInterval(patternSet.getInputs(), d, d2, d3, d4);
        Patterns.mapToInterval(patternSet.getTargets(), d, d2, d3, d4);
    }

    public static void mapInputsToInterval(PatternSet patternSet, double d, double d2, double d3, double d4) {
        Patterns.mapToInterval(patternSet.getInputs(), d, d2, d3, d4);
    }

    public static void mapTargetsToInterval(PatternSet patternSet, double d, double d2, double d3, double d4) {
        Patterns.mapToInterval(patternSet.getTargets(), d, d2, d3, d4);
    }

    private static void mapToInterval(List<List<Double>> list, double d, double d2, double d3, double d4) {
        for (List<Double> list2 : list) {
            for (int i = 0; i < list2.size(); ++i) {
                double d5 = (list2.get(i) - d3) / (d4 - d3) * (d2 - d) + d;
                list2.set(i, d5);
            }
        }
    }

    public static List<Double> encode(int n, int n2, List<Double> list) {
        if (list == null) {
            list = new ArrayList<Double>();
        }
        for (int i = 0; i < n2; ++i) {
            double d = i == n ? 1.0 : 0.0;
            list.add(d);
        }
        return list;
    }

    public static void multiply(PatternSet patternSet, int n) {
        if (n <= 1) {
            return;
        }
        for (List<Double> list : patternSet.getInputs()) {
            int n2 = list.size();
            for (int i = 1; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d = list.get(j);
                    list.add(d);
                }
            }
        }
    }

    public static int getMaxIndex(List<List<Double>> list, int n) {
        List<Double> list2 = list.get(n);
        int n2 = 0;
        for (int i = 1; i < list2.size(); ++i) {
            if (!(list2.get(i) > list2.get(n2))) continue;
            n2 = i;
        }
        return n2;
    }
}

