/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.structure.Map;
import java.util.List;

public class Nets {
    private static int backPos;
    private static int forPos;

    public static Neuron searchNeuron(List<Neuron> list, long l) {
        if (backPos >= list.size()) {
            backPos = 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            Neuron neuron = list.get(backPos);
            if (neuron.getID() == l) {
                return neuron;
            }
            if (--backPos >= 0) continue;
            backPos = list.size() - 1;
        }
        return null;
    }

    public static Link searchLink(List<Link> list, long l) {
        if (backPos >= list.size()) {
            backPos = 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            Link link = list.get(backPos);
            if (link.getID() == l) {
                return link;
            }
            if (--backPos >= 0) continue;
            backPos = list.size() - 1;
        }
        return null;
    }

    public static Link searchDanglingLink(List<Link> list, long l) {
        if (forPos >= list.size()) {
            forPos = 0;
        }
        for (int i = 0; i < list.size(); ++i) {
            Link link = list.get(forPos);
            if (link.isDangling() && link.getID() == l) {
                return link;
            }
            if (++forPos != list.size()) continue;
            forPos = 0;
        }
        return null;
    }

    public static boolean isSame(List<Map> list) {
        String string = list.get(0).toString();
        for (int i = 1; i < list.size(); ++i) {
            if (string.equals(list.get(i).toString())) continue;
            return false;
        }
        return true;
    }

    public static int purify(NeuralNet neuralNet) {
        int n = 0;
        while (true) {
            int n2 = Nets.removeDanglingLinks(neuralNet);
            n += n2;
            n2 = Nets.removeDanglingNeurons(neuralNet);
            if (n2 == 0) break;
            n += n2;
        }
        return n;
    }

    public static int removeDanglingLinks(NeuralNet neuralNet) {
        int n = 0;
        for (int i = 0; i < neuralNet.getNeuronCount(); ++i) {
            Neuron neuron = neuralNet.getNeuron(i);
            for (int j = neuron.getLinkCount() - 1; j >= 0; --j) {
                Link link = neuron.getLink(j);
                if (!link.isDangling()) continue;
                neuron.getLinks().remove(j);
                if (!neuralNet.removeLink(link)) {
                    System.out.println("Warning: removed link not in global list " + link);
                }
                ++n;
            }
        }
        System.out.println("Removed " + n + " links.");
        return n;
    }

    public static int removeDanglingNeurons(NeuralNet neuralNet) {
        int n = 0;
        for (int i = neuralNet.getNeuronCount() - 1; i >= 0; --i) {
            Neuron neuron = neuralNet.getNeuron(i);
            if (!neuron.isHiddenNeuron() || neuron.getInputLinkCount() != 0 && neuron.getOutputLinkCount() != 0) continue;
            neuralNet.removeNeuron(neuron);
            ++n;
        }
        System.out.println("Removed " + n + " neurons.");
        return n;
    }
}

