/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import Jama.Matrix;
import boone.PatternSet;
import java.util.List;

public final class JamaHelper {
    public static Matrix createRowMatrix(PatternSet patternSet) {
        Matrix matrix = new Matrix(patternSet.size(), patternSet.getInputPatternSize());
        int n = 0;
        for (List<Double> list : patternSet.getInputs()) {
            int n2 = 0;
            for (double d : list) {
                matrix.set(n, n2++, d);
            }
            ++n;
        }
        return matrix;
    }

    public static Matrix getRowMean(Matrix matrix) {
        Matrix matrix2 = new Matrix(1, matrix.getColumnDimension());
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            for (int j = 0; j < matrix.getRowDimension(); ++j) {
                matrix2.set(0, i, matrix2.get(0, i) + matrix.get(j, i));
            }
        }
        matrix2.timesEquals(1.0 / (double)matrix.getRowDimension());
        return matrix2;
    }

    public static Matrix getColumnMean(Matrix matrix) {
        Matrix matrix2 = new Matrix(matrix.getRowDimension(), 1);
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            for (int j = 0; j < matrix.getRowDimension(); ++j) {
                matrix2.set(i, 0, matrix2.get(i, 0) + matrix.get(i, 0));
            }
        }
        matrix2.timesEquals(1.0 / (double)matrix.getColumnDimension());
        return matrix2;
    }

    public static Matrix getRowVector(Matrix matrix, int n) {
        Matrix matrix2 = new Matrix(1, matrix.getColumnDimension());
        for (int i = 0; i < matrix.getColumnDimension(); ++i) {
            matrix2.set(0, i, matrix.get(n, i));
        }
        return matrix2;
    }

    public static Matrix getColumnVector(Matrix matrix, int n) {
        Matrix matrix2 = new Matrix(matrix.getRowDimension(), 1);
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            matrix2.set(i, 0, matrix.get(i, n));
        }
        return matrix2;
    }

    public static void normalize(Matrix matrix) {
        matrix.timesEquals(1.0 / matrix.normF());
    }
}

