/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class Common {
    public static Random random = new Random();
    public static DecimalFormat fixedPoint = new DecimalFormat();
    public static DecimalFormat scientific = new DecimalFormat();

    public static int getMaxIndex(double[] dArray) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        return n;
    }

    public static int getMaxIndex(List<Double> list) {
        int n = 0;
        for (int i = 1; i < list.size(); ++i) {
            if (!(list.get(i) > list.get(n))) continue;
            n = i;
        }
        return n;
    }

    public static double getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static double getDuration(double d) {
        return ((double)System.currentTimeMillis() - d) / 1000.0;
    }

    public static double limitToRange(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public static boolean inRange(int n, int n2, int n3) {
        if (n < n2) {
            return false;
        }
        return n < n3;
    }

    public static Random getRandom() {
        return random;
    }

    public static double getRandom(double d, double d2) {
        return random.nextDouble() * (d2 - d) + d;
    }

    public static String cutHeadAtLast(String string, char c) {
        int n = (string = string.trim()).lastIndexOf(c);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String cutTailAtLast(String string, char c) {
        int n = (string = string.trim()).lastIndexOf(c);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String cutLeadChar(String string, char c) {
        if (string.charAt(0) == c) {
            return string.substring(1);
        }
        return string;
    }

    public static String stripOff(String string, char c) {
        char[] cArray = new char[string.length()];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) continue;
            cArray[n++] = c2;
        }
        cArray = Arrays.copyOf(cArray, n);
        return new String(cArray);
    }

    public static char getSeparatorChar(String string) {
        if (string.contains(File.separator)) {
            return File.separatorChar;
        }
        if (string.contains("/")) {
            return '/';
        }
        return '\u0000';
    }

    public static <E> List<E> asList(E[] EArray) {
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, EArray);
        return arrayList;
    }

    public static <E> void replace(List<E> list, E e, E e2) {
        int n = list.indexOf(e);
        if (n != -1) {
            list.set(n, e2);
        }
    }

    public static <E> void swap(List<E> list, int n, int n2) {
        E e = list.get(n);
        list.set(n, list.get(n2));
        list.set(n2, e);
    }

    public static String appendExtension(String string, String string2) {
        int n = string.length();
        if (string.charAt(0) == '\"' && string.charAt(n - 1) == '\"') {
            return string.substring(1, n - 1);
        }
        int n2 = string.lastIndexOf(File.separatorChar);
        int n3 = string.indexOf(46, n2 + 1);
        if (n3 >= 0) {
            return string;
        }
        return string + '.' + string2;
    }

    static {
        fixedPoint.setMinimumFractionDigits(4);
        fixedPoint.setMaximumFractionDigits(4);
        scientific.applyPattern("0.0###E00");
    }
}

