/*
 * Decompiled with CFR 0.152.
 */
package boone.util;

import boone.Boone;
import boone.util.Common;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ClassHelper {
    public static final char JAR_PATH_SEPARATOR_CHAR = '/';
    public static final String JAR_PATH_SEPARATOR_STRING = "/";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final char INNER_CLASS_SEPARATOR_CHAR = '$';

    public static Object instantiateByClassName(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException + ": could not instantiate " + string);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException + ": may not access " + string);
            return null;
        }
        catch (NullPointerException nullPointerException) {
            System.err.println(nullPointerException);
            return null;
        }
    }

    public static Object instantiateByClassName(String string, String[] stringArray, Object[] objectArray) {
        try {
            Class<?> clazz = Class.forName(string);
            if (stringArray == null) {
                return clazz.newInstance();
            }
            Class[] classArray = new Class[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                classArray[i] = ClassHelper.createClassByName(stringArray[i]);
            }
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException + ": could not find constructor for " + string);
            return null;
        }
        catch (InstantiationException instantiationException) {
            System.err.println(instantiationException + ": could not instantiate " + string);
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException + ": may not access " + string);
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("While instantiating " + string + ": " + invocationTargetException);
            System.err.println("With the message: " + invocationTargetException.getMessage());
            return null;
        }
    }

    public static String getBasicName(Class clazz) {
        String string = clazz.getName();
        int n = Math.max(string.lastIndexOf(46), string.lastIndexOf(36));
        return string.substring(n + 1);
    }

    public static String getQualifiedName(String string) {
        if (string.contains(".")) {
            return string;
        }
        String string2 = Boone.getFullName(string);
        if (string2 != null) {
            return string2;
        }
        string2 = ClassHelper.getNameFromClassPath(string + ".class");
        if (string2 != null) {
            char c = Common.getSeparatorChar(string2);
            string2 = Common.cutTailAtLast(string2, '.');
            string2 = Common.cutLeadChar(string2, c);
            string2 = string2.replace(c, '.');
            Boone.setFullName(string, string2);
        }
        return string2;
    }

    public static List<String> getClassPath() {
        String string = System.getProperty("java.class.path");
        List<String> list = Common.asList(string.split(System.getProperty("path.separator")));
        String string2 = "";
        for (String string3 : list) {
            if (!string3.endsWith(".jar")) continue;
            try {
                JarFile jarFile = new JarFile(string3);
                Manifest manifest = jarFile.getManifest();
                jarFile.close();
                string2 = string2 + manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH) + " ";
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string2.length() > 0) {
            Collections.addAll(list, string2.split(" "));
        }
        return list;
    }

    public static String getNameFromClassPath(String string) {
        for (String string2 : Boone.getClassPath()) {
            String string3;
            if (Boone.isExcluded(string2) || (string3 = ClassHelper.getNameFromFileSystem(string2, string)) == null) continue;
            return string3;
        }
        return null;
    }

    public static String getNameFromFileSystem(String string, String string2) {
        File file = new File(string);
        String string3 = null;
        if (file.isDirectory()) {
            string3 = ClassHelper.getNameFromDir(file, string2);
            if (string3 != null) {
                string3 = string3.substring(string.length());
            }
        } else if (string.endsWith(".jar")) {
            string3 = ClassHelper.getNameFromJar(file, string2);
        }
        return string3;
    }

    public static String getNameFromJar(File file, String string) {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (!ClassHelper.containsClassName(string2, string, '/')) continue;
            return string2;
        }
        return null;
    }

    public static String getNameFromDir(File file, String string) {
        File[] fileArray;
        for (File file2 : fileArray = file.listFiles()) {
            String string2;
            if (!(file2.isDirectory() ? (string2 = ClassHelper.getNameFromDir(file2, string)) != null : ClassHelper.containsClassName(string2 = file2.toString(), string, File.separatorChar))) continue;
            return string2;
        }
        return null;
    }

    public static boolean containsClassName(String string, String string2, char c) {
        char c2;
        if (!string.contains(string2)) {
            return false;
        }
        int n = string.lastIndexOf(string2);
        return n > 0 && ((c2 = string.charAt(n - 1)) == c || c2 == '$');
    }

    public static Class createClassByName(String string) throws ClassNotFoundException {
        switch (string) {
            case "int": {
                if (string.contains("[]")) {
                    return int[].class;
                }
                return Integer.TYPE;
            }
            case "long": {
                if (string.contains("[]")) {
                    return long[].class;
                }
                return Long.TYPE;
            }
            case "float": {
                if (string.contains("[]")) {
                    return float[].class;
                }
                return Float.TYPE;
            }
            case "double": {
                if (string.contains("[]")) {
                    return double[].class;
                }
                return Double.TYPE;
            }
            case "boolean": {
                if (string.contains("[]")) {
                    return boolean[].class;
                }
                return Boolean.TYPE;
            }
        }
        return Class.forName(string);
    }

    public static Object getField(Object object, String string) {
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        try {
            return object.getClass().getMethod("get" + string2, new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            try {
                return object.getClass().getMethod("is" + string2, new Class[0]).invoke(object, new Object[0]);
            }
            catch (Exception exception2) {
                try {
                    return object.getClass().getDeclaredField(string).get(object);
                }
                catch (Exception exception3) {
                    throw new RuntimeException("Couldn't get value of field " + string, exception3);
                }
            }
        }
    }

    public static Object getField(Object object, String string, Object object2) {
        try {
            return ClassHelper.getField(object, string);
        }
        catch (RuntimeException runtimeException) {
            return object2;
        }
    }

    public static boolean setField(Object object, String string, Object object2) {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equals(string2)) continue;
            try {
                methodArray[i].invoke(object, object2);
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            object.getClass().getDeclaredField(string).set(object, object2);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

