/*
 * Decompiled with CFR 0.152.
 */
package boone.training;

import boone.BrainPart;
import boone.Neuron;
import boone.training.BackpropTrainer;
import boone.util.Common;
import boone.util.Xml;
import org.jdom2.Element;

public class RpropTrainer
extends BackpropTrainer {
    protected double rateIncFactor = 1.2;
    protected double rateDecFactor = 0.5;
    protected double maxUpdateValue = 50.0;
    protected double minUpdateValue = 1.0E-6;

    public RpropTrainer() {
        this.setLearnRate(0.1);
    }

    @Override
    protected void reset() {
        BrainPart brainPart;
        int n;
        super.reset();
        int n2 = this.net.getNeuronCount();
        for (n = 0; n < n2; ++n) {
            brainPart = this.net.getNeuron(n);
            if (!((Neuron)brainPart).isUsingBias()) continue;
            brainPart.setAccu(this.learnRate);
            brainPart.setLastGradient(Common.getRandom(-0.1, 0.1));
        }
        n2 = this.net.getLinkCount();
        for (n = 0; n < n2; ++n) {
            brainPart = this.net.getLink(n);
            brainPart.setAccu(this.learnRate);
            brainPart.setLastGradient(Common.getRandom(-0.1, 0.1));
        }
    }

    @Override
    protected double calcAdaptation(BrainPart brainPart) {
        double d = brainPart.getGradient();
        double d2 = d * brainPart.getLastGradient();
        double d3 = 0.0;
        brainPart.setLastGradient(d);
        if (d2 != 0.0) {
            d3 = brainPart.getAccu();
            if (d2 > 0.0) {
                d3 = Math.min(this.maxUpdateValue, d3 * this.rateIncFactor);
            } else if (d2 < 0.0) {
                d3 = Math.max(this.minUpdateValue, d3 * this.rateDecFactor);
            }
            brainPart.setAccu(d3);
            if (d > 0.0) {
                d3 = -d3;
            }
        }
        return d3;
    }

    public double getRateIncFactor() {
        return this.rateIncFactor;
    }

    public void setRateIncFactor(double d) {
        this.rateIncFactor = d;
    }

    public double getRateDecFactor() {
        return this.rateDecFactor;
    }

    public void setRateDecFactor(double d) {
        this.rateDecFactor = d;
    }

    public double getMaxUpdateValue() {
        return this.maxUpdateValue;
    }

    public void setMaxUpdateValue(double d) {
        this.maxUpdateValue = d;
    }

    public double getMinUpdateValue() {
        return this.minUpdateValue;
    }

    public void setMinUpdateValue(double d) {
        this.minUpdateValue = d;
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("rateIncFactor", String.valueOf(this.rateIncFactor));
        element2.setAttribute("rateDecFactor", String.valueOf(this.rateDecFactor));
        element2.setAttribute("maxUpdateValue", String.valueOf(this.maxUpdateValue));
        element2.setAttribute("minUpdateValue", String.valueOf(this.minUpdateValue));
        return element2;
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        this.rateIncFactor = Xml.getProperty(element, "rateIncFactor", this.rateIncFactor);
        this.rateDecFactor = Xml.getProperty(element, "rateDecFactor", this.rateDecFactor);
        this.maxUpdateValue = Xml.getProperty(element, "maxUpdateValue", this.maxUpdateValue);
        this.minUpdateValue = Xml.getProperty(element, "minUpdateValue", this.minUpdateValue);
    }
}

