/*
 * Decompiled with CFR 0.152.
 */
package boone.training;

import boone.BrainPart;
import boone.training.BackpropTrainer;
import boone.util.Xml;
import org.jdom2.Element;

public class RMSpropTrainer
extends BackpropTrainer {
    private double gamma = 0.9;
    private double epsilon = 1.0E-7;

    public RMSpropTrainer() {
        this.setLearnRate(0.001);
        this.setBatchSize(32);
    }

    @Override
    protected double calcAdaptation(BrainPart brainPart) {
        double d = brainPart.getGradient();
        double d2 = d * d;
        d2 = this.gamma * d2 + (1.0 - this.gamma) * brainPart.getLastGradient();
        brainPart.setLastGradient(d2);
        return -this.learnRate * (d / Math.sqrt(d2 + this.epsilon));
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        this.gamma = d;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double d) {
        this.epsilon = d;
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("gamma", String.valueOf(this.gamma));
        element2.setAttribute("epsilon", String.valueOf(this.epsilon));
        return element2;
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        this.gamma = Xml.getProperty(element, "gamma", this.gamma);
        this.epsilon = Xml.getProperty(element, "epsilon", this.epsilon);
    }
}

