/*
 * Decompiled with CFR 0.152.
 */
package boone.training;

import boone.Neuron;
import boone.PatternSet;
import boone.map.Topology;
import boone.training.SOMTrainer;
import java.util.List;
import org.jdom2.Element;

public class LVQTrainer
extends SOMTrainer {
    public static final int LVQ1 = 1;
    public static final int OLVQ1 = 2;
    private int flavor = 2;

    public LVQTrainer(Topology topology) {
        super(topology);
    }

    @Override
    public LVQTrainer clone() {
        return (LVQTrainer)super.clone();
    }

    @Override
    protected void reset() {
        int n = this.net.getOutputNeuronCount();
        for (int i = 0; i < n; ++i) {
            Neuron neuron = this.net.getOutputNeuron(i);
            neuron.setErrorSignal(this.learnRate);
        }
    }

    public void setFlavor(int n) {
        this.flavor = n;
    }

    public void train(PatternSet patternSet, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < patternSet.size(); ++j) {
                List<Double> list = patternSet.getInputs().get(j);
                Neuron neuron = this.getWinningNeuron(list);
                String string = patternSet.getTargetLabelOfPattern(j);
                int n2 = string.equals(neuron.getName()) ? 1 : -1;
                double d = neuron.getErrorSignal();
                if (this.flavor == 2) {
                    if ((d /= 1.0 + (double)n2 * d) < 0.0) {
                        d = neuron.getErrorSignal() * 1.1;
                    }
                    neuron.setErrorSignal(d);
                }
                if (d > 1.0) {
                    System.out.println("Learn rate = " + d + " for " + neuron.getName());
                }
                this.train(neuron, list, (double)n2 * d);
            }
        }
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("Flavor", String.valueOf(this.flavor));
        return element2;
    }

    @Override
    public void fromXML(Element element) {
    }
}

