/*
 * Decompiled with CFR 0.152.
 */
package boone.training;

import boone.BrainPart;
import boone.Link;
import boone.Neuron;
import boone.Trainer;
import boone.util.Common;
import java.util.List;
import org.jdom2.Element;

public class HopfieldDeltaTrainer
extends Trainer {
    @Override
    protected void reset() {
    }

    @Override
    protected void endBatch() {
    }

    @Override
    protected void endTrain() {
    }

    @Override
    protected double calcAdaptation(BrainPart brainPart) {
        return 0.0;
    }

    @Override
    public void train(List<Double> list, List<Double> list2) {
        this.net.setInput(list);
        this.net.innervate();
        int n = Common.getRandom().nextInt(this.net.getInputNeuronCount());
        Neuron neuron = this.net.getInputNeuron(n);
        this.train(neuron, list2);
    }

    private void train(Neuron neuron, List<Double> list) {
        double d = list.get(this.net.getNeuronIndex(neuron)) - neuron.getOutput();
        if (d == 0.0) {
            return;
        }
        d *= this.learnRate * neuron.getActivationFn().mapDerivative(neuron.getInput());
        for (Link link : neuron.getLinks()) {
            if (!link.isInputOf(neuron)) continue;
            Neuron neuron2 = link.getOtherNeuron(neuron);
            int n = this.net.getNeuronIndex(neuron2);
            link.addToWeight(d * list.get(n));
        }
        if (neuron.isUsingBias()) {
            neuron.addToBias(d);
        }
    }

    @Override
    public void fromXML(Element element) {
    }
}

