/*
 * Decompiled with CFR 0.152.
 */
package boone.training;

import boone.NeuralNet;
import boone.Neuron;
import boone.map.Function;
import boone.training.TrainingSignalGenerator;
import boone.util.Common;
import java.util.List;

public class CrossEntropy
extends TrainingSignalGenerator {
    private static final Function softMax = new Function.SoftMax();
    private double[] output;

    @Override
    public void computeErrorSignal(NeuralNet neuralNet, List<Double> list, List<Double> list2) {
        neuralNet.setInput(list);
        neuralNet.innervate();
        this.output = neuralNet.getOutput(this.output);
        int n = Common.getMaxIndex(list2);
        softMax.setParameters(this.output);
        softMax.map(-1.0);
        for (int i = 0; i < this.output.length; ++i) {
            Neuron neuron = neuralNet.getOutputNeuron(i);
            neuron.setErrorSignal(i == n ? this.output[i] - 1.0 : this.output[i]);
        }
    }

    @Override
    public double computeError(NeuralNet neuralNet, List<Double> list, List<Double> list2) {
        neuralNet.setInput(list);
        neuralNet.innervate();
        this.output = neuralNet.getOutput(this.output);
        int n = Common.getMaxIndex(list2);
        softMax.setParameters(this.output);
        return -Math.log(softMax.map(n));
    }
}

