/*
 * Decompiled with CFR 0.152.
 */
package boone.training;

import boone.BrainPart;
import boone.Link;
import boone.Neuron;
import boone.Trainer;
import java.util.List;

public class BackpropTrainer
extends Trainer {
    @Override
    protected void reset() {
        int n;
        int n2 = this.net.getNeuronCount();
        for (n = 0; n < n2; ++n) {
            this.net.getNeuron(n).reset();
        }
        n2 = this.net.getLinkCount();
        for (n = 0; n < n2; ++n) {
            this.net.getLink(n).reset();
        }
    }

    @Override
    protected void train(List<Double> list, List<Double> list2) {
        this.trainingSignalGenerator.computeErrorSignal(this.net, list, list2);
        for (int i = this.net.getNeuronCount() - 1; i >= 0; --i) {
            Neuron neuron = this.net.getNeuron(i);
            if (neuron.getErrorSignal() == 0.0) continue;
            this.train(neuron);
            if (neuron.isInputNeuron()) continue;
            for (Link link : neuron.getLinks()) {
                if (!link.isInputOf(neuron) || link.getSource() == null) continue;
                this.train(link);
            }
        }
        this.endPattern();
    }

    protected void endPattern() {
        int n = this.net.getNeuronCount();
        for (int i = 0; i < n; ++i) {
            this.net.getNeuron(i).setErrorSignal(0.0);
        }
    }

    @Override
    protected void endTrain() {
    }

    protected void train(Neuron neuron) {
        double d = neuron.getErrorSignal() * neuron.getActivationFn().mapDerivative(neuron.getInput());
        neuron.setErrorSignal(d);
        if (neuron.isUsingBias()) {
            neuron.addGradient(d);
        }
    }

    protected void train(Link link) {
        Neuron neuron = link.getSource();
        Neuron neuron2 = link.getSink();
        double d = neuron2.getErrorSignal();
        neuron.setErrorSignal(neuron.getErrorSignal() + d * link.getWeight());
        link.addGradient(d * neuron.getOutput());
    }

    @Override
    protected double calcAdaptation(BrainPart brainPart) {
        return -this.learnRate * brainPart.getGradient();
    }
}

