/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import boone.Link;
import boone.NeuralNet;
import boone.map.Function;
import boone.structure.CompiledNeuralNet;
import org.ujmp.core.Matrix;

public class NeuralNetCompiler {
    protected NeuralNet inputNet;
    protected CompiledNeuralNet outputNet;

    public CompiledNeuralNet compile(NeuralNet neuralNet) throws CompileException {
        this.inputNet = neuralNet;
        this.outputNet = new CompiledNeuralNet();
        this.outputNet.numberOfLayers = neuralNet.getOutputNeuron(0).getLayer() == -1 ? 1 : neuralNet.getOutputNeuron(0).getLayer() + 1;
        int n = neuralNet.getNeuronCount();
        this.outputNet.neuronMatrices = new Matrix[this.outputNet.numberOfLayers];
        this.outputNet.neuronFunctions = new Function[n];
        this.outputNet.neuronBias = new double[n];
        this.fillNeuronMatrices();
        this.outputNet.linkMatrices = this.outputNet.numberOfLayers == 1 ? new Matrix[1] : new Matrix[this.outputNet.numberOfLayers - 1];
        this.fillLinkMatrices();
        return this.outputNet;
    }

    private void fillLinkMatrices() throws CompileException {
        int n = 0;
        int n2 = 0;
        int n3 = this.inputNet.getLinkCount();
        if (this.outputNet.numberOfLayers != 1) {
            int n4;
            for (n4 = 0; n4 < this.inputNet.getLinkCount(); ++n4) {
                Link link = this.inputNet.getLink(n4);
                if (link.getSource().getLayer() + 1 == link.getSink().getLayer()) continue;
                throw new CompileException("Multi-layer link detected");
            }
            while (n < this.outputNet.numberOfLayers - 1) {
                double[][] dArray = new double[(int)this.outputNet.neuronMatrices[n + 1].getRowCount()][(int)this.outputNet.neuronMatrices[n].getRowCount()];
                n2 += (int)this.outputNet.neuronMatrices[n].getRowCount();
                for (n4 = 0; n4 < n3; ++n4) {
                    if (this.inputNet.getLink(n4).getSource().getLayer() != n || this.inputNet.getLink(n4).getSink().getLayer() != n + 1) continue;
                    dArray[(int)(this.inputNet.getLink((int)n4).getSink().getID() - (long)n2)][(int)(this.inputNet.getLink((int)n4).getSource().getID() - (long)(n2 - (int)this.outputNet.neuronMatrices[n].getRowCount()))] = this.inputNet.getLink(n4).getWeight();
                }
                this.outputNet.linkMatrices[n] = Matrix.Factory.importFromArray(dArray);
                ++n;
            }
        } else {
            double[][] dArray = new double[this.inputNet.getNeuronCount()][this.inputNet.getNeuronCount()];
            for (int i = 0; i < n3; ++i) {
                dArray[(int)this.inputNet.getLink((int)i).getSink().getID()][(int)this.inputNet.getLink((int)i).getSource().getID()] = this.inputNet.getLink(i).getWeight();
            }
            this.outputNet.linkMatrices[0] = Matrix.Factory.importFromArray(dArray);
        }
    }

    private void fillNeuronMatrices() {
        int n;
        int[] nArray = new int[this.outputNet.numberOfLayers];
        double[] dArray = new double[this.inputNet.getNeuronCount()];
        for (n = 0; n < this.inputNet.getNeuronCount(); ++n) {
            if (this.inputNet.getNeuron(n).getLayer() == -1) {
                dArray[n] = this.inputNet.getNeuron(n).getInput();
            } else {
                int n2 = this.inputNet.getNeuron(n).getLayer();
                nArray[n2] = nArray[n2] + 1;
            }
            this.outputNet.neuronFunctions[n] = this.inputNet.getNeuron(n).getActivationFn();
            this.outputNet.neuronBias[n] = this.inputNet.getNeuron(n).getBias();
        }
        if (this.inputNet.getNeuron(0).getLayer() == -1) {
            this.outputNet.neuronMatrices[0] = Matrix.Factory.importFromArray((double[][])new double[][]{dArray});
        } else {
            for (n = 0; n < this.outputNet.numberOfLayers; ++n) {
                this.outputNet.neuronMatrices[n] = Matrix.Factory.zeros((long)nArray[n], 1L);
            }
        }
    }

    public class CompileException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CompileException() {
        }

        public CompileException(String string) {
            super(string);
        }

        public CompileException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public CompileException(Throwable throwable) {
            super(throwable);
        }
    }
}

