/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.PatternSet;
import boone.Trainer;
import boone.map.Function;
import boone.map.Position;
import boone.map.Topology;
import boone.spike.SpikingLink;
import boone.spike.SpikingNeuralNet;
import boone.spike.SpikingNeuron;
import boone.structure.FeedForwardLayer;
import boone.structure.Layer;
import boone.training.HopfieldDeltaTrainer;
import boone.training.RpropTrainer;
import boone.training.SOMTrainer;
import boone.util.JamaHelper;
import boone.util.Patterns;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetFactory {
    public static NeuralNet createFeedForward(int[] nArray, boolean bl, Trainer trainer, Neuron neuron, Link link) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>(nArray.length);
        for (int n : nArray) {
            arrayList.add(new FeedForwardLayer(n, neuron, link));
        }
        Object object = new NeuralNet();
        if (trainer == null) {
            trainer = new RpropTrainer();
        }
        ((NeuralNet)object).setTrainer(trainer);
        return NetFactory.generateFeedForward((NeuralNet)object, arrayList, bl, true);
    }

    public static NeuralNet createFeedForward(List<Layer> list, Trainer trainer, boolean bl) {
        if (trainer == null) {
            trainer = new RpropTrainer();
        }
        NeuralNet neuralNet = new NeuralNet();
        neuralNet.setTrainer(trainer);
        return NetFactory.generateFeedForward(neuralNet, list, false, bl);
    }

    public static SpikingNeuralNet createFeedForward(int[] nArray, boolean bl, SpikingNeuron spikingNeuron, SpikingLink spikingLink) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>(nArray.length);
        if (spikingNeuron == null) {
            spikingNeuron = new SpikingNeuron();
        }
        for (int n : nArray) {
            arrayList.add(new FeedForwardLayer(n, spikingNeuron, spikingLink));
        }
        SpikingNeuralNet spikingNeuralNet = new SpikingNeuralNet();
        return (SpikingNeuralNet)NetFactory.generateFeedForward(spikingNeuralNet, arrayList, bl, true);
    }

    public static NeuralNet createSOM(SOMTrainer sOMTrainer, PatternSet patternSet) {
        Neuron neuron = new Neuron(new Function.Identity());
        NeuralNet neuralNet = NetFactory.createFeedForward(new int[]{patternSet.getInputPatternSize(), sOMTrainer.getTopology().getTotalNeurons()}, false, sOMTrainer, neuron, null);
        return NetFactory.generateSOM(neuralNet, patternSet);
    }

    public static NeuralNet createHopfield(int n, Function function, Trainer trainer, Neuron neuron, Link link) {
        if (function == null) {
            function = new Function.AtLeast(0.0);
        }
        if (trainer == null) {
            trainer = new HopfieldDeltaTrainer();
        }
        if (neuron == null) {
            neuron = new Neuron(function);
        }
        if (link == null) {
            link = new Link();
        }
        return NetFactory.generateHopfield(new NeuralNet(), n, trainer, neuron, link);
    }

    public static SpikingNeuralNet createHopfield(int n, Function function, Function function2, Trainer trainer, Neuron neuron, Link link) {
        if (neuron == null) {
            neuron = new SpikingNeuron();
            if (function != null) {
                neuron.setActivationFn(function);
            }
        }
        if (link == null) {
            link = new SpikingLink();
            if (function2 != null) {
                link.setActivationFn(function2);
            }
        }
        SpikingNeuralNet spikingNeuralNet = new SpikingNeuralNet();
        NetFactory.generateHopfield(spikingNeuralNet, n, trainer, neuron, link);
        return spikingNeuralNet;
    }

    private static NeuralNet generateFeedForward(NeuralNet neuralNet, List<Layer> list, boolean bl, boolean bl2) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        Iterator<Layer> iterator = list.iterator();
        while (iterator.hasNext()) {
            Layer layer;
            int n = list.indexOf(layer = iterator.next());
            layer.setIOType(n == 0, n == list.size() - 1);
            for (Layer layer2 : arrayList) {
                layer.connect(layer2);
            }
            neuralNet.addLayer(layer);
            if (!bl) {
                arrayList.clear();
            }
            arrayList.add(layer);
        }
        if (bl2) {
            neuralNet.randomize();
        }
        neuralNet.setTopology(1);
        return neuralNet;
    }

    private static NeuralNet generateSOM(NeuralNet neuralNet, PatternSet patternSet) {
        for (int i = 0; i < neuralNet.getOutputNeuronCount(); ++i) {
            Neuron neuron = neuralNet.getOutputNeuron(i);
            neuron.setUsingBias(false);
        }
        SOMTrainer sOMTrainer = (SOMTrainer)neuralNet.getTrainer();
        sOMTrainer.getTopology().arrangeNeurons();
        Patterns.normalizeInputs(patternSet);
        return NetFactory.assignWeights(neuralNet, patternSet);
    }

    private static NeuralNet assignWeights(NeuralNet neuralNet, PatternSet patternSet) {
        Matrix matrix = JamaHelper.createRowMatrix(patternSet);
        Matrix matrix2 = JamaHelper.getRowMean(matrix);
        Matrix matrix3 = new Matrix(matrix.getRowDimension(), 1, 1.0);
        matrix.minusEquals(matrix3.times(matrix2));
        SingularValueDecomposition singularValueDecomposition = matrix.svd();
        Matrix matrix4 = JamaHelper.getColumnVector(singularValueDecomposition.getV(), 0);
        JamaHelper.normalize(matrix4);
        Matrix matrix5 = JamaHelper.getColumnVector(singularValueDecomposition.getV(), 1);
        JamaHelper.normalize(matrix5);
        double d = singularValueDecomposition.getSingularValues()[0];
        d *= d;
        double d2 = singularValueDecomposition.getSingularValues()[1];
        d2 *= d2;
        SOMTrainer sOMTrainer = (SOMTrainer)neuralNet.getTrainer();
        Topology topology = sOMTrainer.getTopology();
        double[] dArray = topology.getSizes();
        int n = dArray[1] > dArray[0] ? 1 : 0;
        double d3 = d / dArray[n];
        double d4 = d2 / dArray[(n + 1) % 2];
        Matrix matrix6 = matrix4.times(d / 2.0).plus(matrix5.times(d2 / 2.0));
        matrix2 = matrix2.transpose();
        Matrix matrix7 = matrix2.minus(matrix6);
        for (int i = 0; i < neuralNet.getOutputNeuronCount(); ++i) {
            Neuron neuron = neuralNet.getOutputNeuron(i);
            Position position = neuron.getPosition();
            float f = n == 0 ? position.getYPos() : position.getXPos();
            float f2 = n == 0 ? position.getXPos() : position.getYPos();
            Matrix matrix8 = matrix4.times((double)f * d3).plus(matrix5.times((double)f2 * d4));
            matrix8 = matrix8.plusEquals(matrix7);
            for (int j = 0; j < neuralNet.getInputNeuronCount(); ++j) {
                Neuron neuron2 = neuralNet.getInputNeuron(j);
                neuron2.getLinkTo(neuron).setWeight(matrix8.get(j, 0));
            }
        }
        return neuralNet;
    }

    private static Neuron createNeuron(Neuron neuron) {
        neuron = neuron.clone();
        neuron.setInputNeuron(true);
        neuron.setOutputNeuron(true);
        neuron.setUsingBias(true);
        neuron.randomize();
        neuron.setName("Neuron");
        return neuron;
    }

    private static Link createLink(Link link, Neuron neuron, Neuron neuron2) {
        link = link.clone();
        link.setSource(neuron);
        link.setSink(neuron2);
        link.randomize(-0.1, 0.1);
        link.setName("Link");
        return link;
    }

    private static NeuralNet generateHopfield(NeuralNet neuralNet, int n, Trainer trainer, Neuron neuron, Link link) {
        neuralNet.setMaxCycles(100);
        neuralNet.setZeroInputAfterFirstCycle(true);
        for (int i = 0; i < n; ++i) {
            Neuron neuron2 = NetFactory.createNeuron(neuron);
            for (int j = 0; j < neuralNet.getNeuronCount(); ++j) {
                link = NetFactory.createLink(link, neuralNet.getNeuron(j), neuron2);
                link.setDirected(false);
                neuralNet.addLink(link);
            }
            neuralNet.addNeuron(neuron2);
        }
        neuralNet.setTrainer(trainer);
        return neuralNet;
    }
}

