/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import boone.BrainPart;
import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.map.Function;
import boone.neurons.NeuronList;
import boone.util.Common;
import java.util.Hashtable;
import java.util.Random;

public class NetCompiler {
    public static CompiledNet compile(NeuralNet neuralNet) throws CompileException {
        return new BooneCompiledNet().compile(neuralNet);
    }

    protected static class BooneCompiledNet
    implements CompiledNet {
        protected int numNeurons;
        protected int numInputNeurons;
        protected int[] inputNeurons;
        protected int numOutputNeurons;
        protected int[] outputNeurons;
        protected int numLinks;
        protected Function[] activationFn;
        protected boolean[] usingBias;
        protected boolean[] loopOutputToInput;
        protected double[] bias;
        protected double[] externalInput;
        protected double[] linkInput;
        protected double[] input;
        protected double[] output;
        protected int[][] outLinks;
        protected int[] linkSourceNeuron;
        protected int[] linkSinkNeuron;
        protected double[] weight;
        protected double[] value;
        protected boolean[] directed;
        protected int maxCycles = 1;
        protected boolean zeroInputAfterFirstCycle = false;
        protected int calcOrder;
        protected int[] tickList = null;

        protected BooneCompiledNet() {
        }

        @Override
        public void setInput(double[] dArray) {
            for (int i = 0; i < dArray.length; ++i) {
                this.externalInput[this.inputNeurons[i]] = dArray[i];
            }
        }

        @Override
        public void innervate() {
            int n;
            if (this.calcOrder == 1) {
                n = this.numNeurons;
                for (int i = 0; i < n; ++i) {
                    this.tickList[i] = i;
                }
                Random random = Common.getRandom();
                for (int i = n - 1; i >= 0; --i) {
                    int n2 = random.nextInt(i);
                    int n3 = this.tickList[n2];
                    this.tickList[n2] = this.tickList[i];
                    this.tickList[i] = n3;
                }
            }
            for (n = 0; n < this.maxCycles; ++n) {
                this.innervateCycle(n);
            }
            for (n = this.numNeurons - 1; n >= 0; --n) {
                this.linkInput[n] = 0.0;
            }
        }

        protected void innervateCycle(int n) {
            int n2;
            if (this.calcOrder == 2) {
                for (n2 = 0; n2 < this.numNeurons; ++n2) {
                    this.calculateNeuron(n2);
                }
                for (n2 = 0; n2 < this.numNeurons; ++n2) {
                    this.propagateNeuronOutput(n2);
                }
            } else if (this.calcOrder == 1) {
                for (n2 = 0; n2 < this.numNeurons; ++n2) {
                    this.calculateNeuron(this.tickList[n2]);
                    this.propagateNeuronOutput(this.tickList[n2]);
                }
            } else {
                for (n2 = 0; n2 < this.numNeurons; ++n2) {
                    this.calculateNeuron(n2);
                    this.propagateNeuronOutput(n2);
                }
            }
            if (this.zeroInputAfterFirstCycle && n == 0) {
                for (n2 = 0; n2 < this.numInputNeurons; ++n2) {
                    this.externalInput[n2] = 0.0;
                }
            }
        }

        protected void calculateNeuron(int n) {
            Function function;
            this.input[n] = this.linkInput[n] + this.externalInput[n];
            if (this.usingBias[n]) {
                int n2 = n;
                this.input[n2] = this.input[n2] + this.bias[n];
            }
            this.output[n] = (function = this.activationFn[n]) == null ? this.input[n] : function.map(this.input[n]);
            this.linkInput[n] = 0.0;
        }

        protected void propagateNeuronOutput(int n) {
            int[] nArray = this.outLinks[n];
            int n2 = nArray.length;
            double d = this.output[n];
            for (int i = n2 - 1; i >= 0; --i) {
                int n3;
                this.propagateLink(n3, d, this.linkSourceNeuron[n3 = nArray[i]] == n);
            }
        }

        protected void propagateLink(int n, double d, boolean bl) {
            double d2 = d * this.weight[n];
            if (bl) {
                int n2 = this.linkSinkNeuron[n];
                this.linkInput[n2] = this.linkInput[n2] + d2;
                this.value[n] = d2;
            } else {
                int n3 = this.linkSourceNeuron[n];
                this.linkInput[n3] = this.linkInput[n3] + d2;
            }
        }

        @Override
        public double[] getOutput(double[] dArray) {
            if (dArray == null || dArray.length < this.numOutputNeurons) {
                dArray = new double[this.numOutputNeurons];
            }
            for (int i = 0; i < this.numOutputNeurons; ++i) {
                dArray[i] = this.output[this.outputNeurons[i]];
            }
            return dArray;
        }

        @Override
        public CompiledNet compile(NeuralNet neuralNet) throws CompileException {
            BrainPart brainPart;
            int n;
            this.numNeurons = neuralNet.getNeuronCount();
            this.activationFn = new Function[this.numNeurons];
            this.usingBias = new boolean[this.numNeurons];
            this.loopOutputToInput = new boolean[this.numNeurons];
            this.bias = new double[this.numNeurons];
            this.externalInput = new double[this.numNeurons];
            this.linkInput = new double[this.numNeurons];
            this.input = new double[this.numNeurons];
            this.output = new double[this.numNeurons];
            this.outLinks = new int[this.numNeurons][];
            NeuronList neuronList = new NeuronList();
            if (neuronList.size() < this.numNeurons) {
                throw new CompileException("CreateTickList does not add all neurons. Probably invalid sort order.");
            }
            Hashtable hashtable = new Hashtable(neuronList.size());
            for (int i = neuronList.size() - 1; i >= 0; --i) {
                hashtable.put(neuronList.get(i), i);
            }
            this.numLinks = neuralNet.getLinkCount();
            Hashtable<Link, Integer> hashtable2 = new Hashtable<Link, Integer>(this.numLinks);
            for (n = this.numLinks - 1; n >= 0; --n) {
                hashtable2.put(neuralNet.getLink(n), n);
            }
            for (n = neuronList.size() - 1; n >= 0; --n) {
                brainPart = (Neuron)neuronList.get(n);
                this.activationFn[n] = brainPart.getActivationFn();
                this.usingBias[n] = ((Neuron)brainPart).isUsingBias();
                this.bias[n] = ((Neuron)brainPart).getBias();
                this.externalInput[n] = ((Neuron)brainPart).getExternalInput();
                this.linkInput[n] = ((Neuron)brainPart).getLinkInput();
                this.input[n] = ((Neuron)brainPart).getInput();
                this.output[n] = ((Neuron)brainPart).getOutput();
                int n2 = ((Neuron)brainPart).getOutputLinkCount();
                this.outLinks[n] = new int[n2];
                for (int i = n2 - 1; i >= 0; --i) {
                    this.outLinks[n][i] = (Integer)hashtable2.get(((Neuron)brainPart).getOutputLink(i));
                }
            }
            this.numInputNeurons = neuralNet.getInputNeuronCount();
            this.inputNeurons = new int[this.numInputNeurons];
            for (n = this.numInputNeurons - 1; n >= 0; --n) {
                this.inputNeurons[n] = (Integer)hashtable.get(neuralNet.getInputNeuron(n));
            }
            this.numOutputNeurons = neuralNet.getOutputNeuronCount();
            this.outputNeurons = new int[this.numOutputNeurons];
            for (n = this.numOutputNeurons - 1; n >= 0; --n) {
                this.outputNeurons[n] = (Integer)hashtable.get(neuralNet.getOutputNeuron(n));
            }
            this.linkSourceNeuron = new int[this.numLinks];
            this.linkSinkNeuron = new int[this.numLinks];
            this.weight = new double[this.numLinks];
            this.value = new double[this.numLinks];
            this.directed = new boolean[this.numLinks];
            for (n = 0; n < this.numLinks; ++n) {
                brainPart = neuralNet.getLink(n);
                this.linkSourceNeuron[n] = (Integer)hashtable.get(((Link)brainPart).getSource());
                this.linkSinkNeuron[n] = (Integer)hashtable.get(((Link)brainPart).getSink());
                this.weight[n] = brainPart.getWeight();
                this.value[n] = ((Link)brainPart).getValue();
                this.directed[n] = ((Link)brainPart).isDirected();
            }
            this.maxCycles = neuralNet.getMaxCycles();
            this.zeroInputAfterFirstCycle = neuralNet.getZeroInputAfterFirstCycle();
            this.calcOrder = 0;
            return this;
        }
    }

    public static class CompileException
    extends Exception {
        public CompileException() {
        }

        public CompileException(String string) {
            super(string);
        }

        public CompileException(Throwable throwable) {
            super(throwable);
        }

        public CompileException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }

    public static interface CompiledNet {
        public void setInput(double[] var1);

        public void innervate();

        public double[] getOutput(double[] var1);

        public CompiledNet compile(NeuralNet var1) throws CompileException;
    }
}

