/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import boone.Link;
import boone.Neuron;
import boone.map.Function;
import boone.neurons.NeuronList;
import boone.structure.Layer;
import boone.util.Xml;
import org.jdom2.Element;

public abstract class Map
extends Layer
implements Cloneable {
    protected int width;
    protected int height;
    protected Neuron neuron;
    protected Link link;
    protected NeuronList neurons;

    public Map() {
    }

    public Map(Map map) {
        this(map.getWidth(), map.getHeight());
        this.neuron = map.neuron;
        this.link = map.link;
        this.neurons = new NeuronList();
        for (Neuron neuron : map.getNeurons()) {
            Neuron neuron2 = neuron.clone();
            for (Link link : neuron.getLinks()) {
                Link link2 = link.clone();
                if (!link.isInputOf(neuron)) continue;
                link2.setSink(neuron2);
            }
            this.neurons.add(neuron2);
        }
    }

    public Map(int n) {
        this(n, n);
    }

    public Map(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Map clone() {
        Map map;
        try {
            map = (Map)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        if (this.neurons != null) {
            map.neurons = new NeuronList();
        }
        return map;
    }

    public void reset() {
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getDepth() {
        return 1;
    }

    @Override
    public int getSize() {
        return this.width * this.height;
    }

    @Override
    public NeuronList getNeurons() {
        return this.neurons;
    }

    public Neuron getNeuron(int n) {
        return (Neuron)this.neurons.get(n);
    }

    protected Neuron getNeuron(int n, int n2) {
        return (Neuron)this.neurons.get(n * this.width + n2);
    }

    @Override
    public int getLinkCount() {
        if (this.neurons == null) {
            return 0;
        }
        int n = 0;
        for (Neuron neuron : this.neurons) {
            n += neuron.getInputLinkCount();
        }
        return n;
    }

    @Override
    protected void setIOType(boolean bl, boolean bl2) {
        if (this.neuron == null) {
            this.neuron = new Neuron();
            if (bl) {
                this.neuron.setUsingBias(false);
                this.neuron.setActivationFn(new Function.Identity());
            }
        }
        this.neuron.setInputNeuron(bl);
        this.neuron.setOutputNeuron(bl2);
        if (this.neurons == null) {
            this.neurons = new NeuronList(this.getSize(), this.neuron);
        }
    }

    @Override
    public boolean connect(Layer layer) {
        if (layer.getDepth() == 0) {
            return false;
        }
        if (layer.getMaps() == null) {
            return this.connect((Map)layer);
        }
        boolean bl = false;
        for (Map map : layer.getMaps()) {
            bl |= this.connect(map);
        }
        return bl;
    }

    @Override
    public void disconnect() {
        for (Neuron neuron : this.neurons) {
            for (Link link : neuron.getLinks()) {
                if (!link.isInputOf(neuron)) continue;
                link.setSource(null);
                link.setTrainable(false);
            }
        }
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "map", this);
        element2.setAttribute("size", this.width + "x" + this.height);
        return element2;
    }

    @Override
    public String toString() {
        return "(" + this.width + "x" + this.height + ")";
    }

    protected abstract boolean connect(Map var1);
}

