/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import boone.Neuron;
import boone.io.Storable;
import boone.neurons.NeuronList;
import boone.structure.Map;
import boone.util.Nets;
import boone.util.Xml;
import java.util.ArrayList;
import org.jdom2.Element;

public class Layer
implements Storable {
    ArrayList<Map> maps;
    private int level;

    public int getWidth() {
        if (this.maps.size() == 0) {
            return 0;
        }
        return this.maps.get(0).getWidth();
    }

    public int getHeight() {
        if (this.maps.size() == 0) {
            return 0;
        }
        return this.maps.get(0).getHeight();
    }

    public int getDepth() {
        return this.maps.size();
    }

    public int getSize() {
        int n = 0;
        for (Map map : this.maps) {
            n += map.getSize();
        }
        return n;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public NeuronList getNeurons() {
        if (this.maps == null || this.maps.size() == 0) {
            return null;
        }
        NeuronList neuronList = new NeuronList();
        for (Map map : this.maps) {
            neuronList.addAll(map.getNeurons());
        }
        return neuronList;
    }

    public ArrayList<Map> getMaps() {
        return this.maps;
    }

    public void addMap(Map map) {
        if (map == null) {
            return;
        }
        if (this.maps == null) {
            this.maps = new ArrayList(1);
        }
        this.maps.add(map);
    }

    protected void addMap(Map map, int n) {
        if (this.maps == null) {
            this.maps = new ArrayList(n);
        }
        this.addMap(map);
        for (int i = 1; i < n; ++i) {
            this.addMap(map.clone());
        }
    }

    protected Map removeMap(int n) {
        if (this.maps == null) {
            return null;
        }
        return this.maps.remove(n);
    }

    public int getMapCount() {
        if (this.maps == null) {
            return 0;
        }
        return this.maps.size();
    }

    public int getLinkCount() {
        int n = 0;
        for (Map map : this.maps) {
            n += map.getLinkCount();
        }
        return n;
    }

    protected void setIOType(boolean bl, boolean bl2) {
        for (Map map : this.maps) {
            map.setIOType(bl, bl2);
        }
    }

    protected Neuron getNeuron(int n, int n2, int n3) {
        return this.maps.get(n3).getNeuron(n, n2);
    }

    public boolean connect(Layer layer) {
        boolean bl = false;
        for (Map map : this.maps) {
            bl |= map.connect(layer);
        }
        return bl;
    }

    public void disconnect() {
        for (Map map : this.maps) {
            map.disconnect();
        }
    }

    @Override
    public void fromXML(Element element) {
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "layer", this);
        element2.setAttribute("level", String.valueOf(this.level));
        for (Map map : this.maps) {
            map.toXML(element2);
        }
        return element2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (this.maps.size() > 1 && Nets.isSame(this.maps)) {
            Map map = this.maps.get(0);
            stringBuilder.append(map.getWidth()).append("x").append(map.getHeight()).append("x").append(this.getDepth());
        } else {
            for (Map map : this.maps) {
                stringBuilder.append("[").append(map).append("]");
            }
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

