/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import boone.Link;
import boone.Neuron;
import boone.neurons.NeuronList;
import boone.structure.ConvolutionMap;
import boone.structure.Map;
import boone.util.Common;
import java.util.ArrayList;
import java.util.List;

public abstract class FilterMap
extends Map {
    protected int filterWidth;
    protected int filterHeight;
    protected int padWidth;
    protected int padHeight;
    protected int strideWidth;
    protected int strideHeight;
    protected List<Link[][]> filters;
    protected int connectedFilters;

    FilterMap(int n, int n2, int n3, int n4, int n5, int n6) {
        this.filterWidth = n;
        this.filterHeight = n2;
        this.padWidth = n3;
        this.padHeight = n4;
        this.strideWidth = n5;
        this.strideHeight = n6;
        this.neurons = new NeuronList();
        this.filters = new ArrayList<Link[][]>();
    }

    FilterMap(Map map) {
        super(map);
        this.filterWidth = ((FilterMap)map).filterWidth;
        this.filterHeight = ((FilterMap)map).filterHeight;
        this.padWidth = ((FilterMap)map).padWidth;
        this.padHeight = ((FilterMap)map).padHeight;
        this.strideWidth = ((FilterMap)map).strideWidth;
        this.strideHeight = ((FilterMap)map).strideHeight;
        ConvolutionMap convolutionMap = (ConvolutionMap)map;
        int n = convolutionMap.getFilters().size();
        this.filters = new ArrayList<Link[][]>(n);
        for (int i = 0; i < n; ++i) {
            Link[][] linkArray = convolutionMap.getFilters().get(i);
            Link[][] linkArray2 = new Link[this.filterWidth][this.filterHeight];
            for (int j = 0; j < this.filterWidth; ++j) {
                for (int k = 0; k < this.filterHeight; ++k) {
                    linkArray2[j][k] = linkArray[j][k].clone();
                }
            }
            this.filters.add(linkArray2);
        }
    }

    public int getFilterWidth() {
        return this.filterWidth;
    }

    public int getFilterHeight() {
        return this.filterHeight;
    }

    public int getPadWidth() {
        return this.padWidth;
    }

    public int getPadHeight() {
        return this.padHeight;
    }

    public int getStrideWidth() {
        return this.strideWidth;
    }

    public int getStrideHeight() {
        return this.strideHeight;
    }

    public List<Link[][]> getFilters() {
        return this.filters;
    }

    private int adaptWidth(Map map) {
        int n = map.getWidth() - this.filterWidth + 2 * this.padWidth;
        if (n <= 0) {
            return 1;
        }
        return n / this.strideWidth + 1;
    }

    private int adaptHeight(Map map) {
        int n = map.getHeight() - this.filterHeight + 2 * this.padHeight;
        if (n <= 0) {
            return 1;
        }
        return n / this.strideHeight + 1;
    }

    private void adaptNeurons() {
        for (int i = this.neurons.size(); i < this.getSize(); ++i) {
            this.neurons.add(this.neuron.clone());
        }
    }

    @Override
    public boolean connect(Map map) {
        if (map == null || map.getNeurons() == null || map.getNeurons().size() == 0) {
            return false;
        }
        this.width = this.adaptWidth(map);
        this.height = this.adaptHeight(map);
        this.adaptNeurons();
        if (this.filters.size() <= this.connectedFilters) {
            this.createFilter();
        }
        int n = 0;
        int n2 = 0;
        int n3 = -this.padHeight;
        while (n2 < this.height) {
            int n4 = 0;
            int n5 = -this.padWidth;
            while (n4 < this.width) {
                this.attachFilter(n3, n5, map, (Neuron)this.neurons.get(n++));
                ++n4;
                n5 += this.strideWidth;
            }
            ++n2;
            n3 += this.strideHeight;
        }
        ++this.connectedFilters;
        if (n != this.getSize()) {
            System.out.println("Panic! " + n + " (out of " + this.getSize() + ") detectors attached");
        }
        return true;
    }

    protected void attachFilter(int n, int n2, Map map, Neuron neuron) {
        int n3;
        Link[][] linkArray = this.filters.get(this.connectedFilters);
        if (this.connectedFilters == 0 && (n3 = this.getConnectedLinks(neuron)) > 0) {
            System.out.println("Panic! " + neuron + " already has " + n3 + " connected links.");
        }
        for (n3 = 0; n3 < this.filterHeight; ++n3) {
            if (!Common.inRange(n + n3, 0, map.getHeight())) continue;
            for (int i = 0; i < this.filterWidth; ++i) {
                if (!Common.inRange(n2 + i, 0, map.getWidth())) continue;
                Neuron neuron2 = map.getNeuron(n + n3, n2 + i);
                Link link = this.getFilterLink(neuron, linkArray[n3][i]);
                link.setSource(neuron2);
                link.setSink(neuron);
            }
        }
    }

    private int getConnectedLinks(Neuron neuron) {
        int n = 0;
        for (Link link : neuron.getLinks()) {
            if (!link.isInputOf(neuron) || link.isDangling()) continue;
            ++n;
        }
        return n;
    }

    private void printFilter(int n) {
        System.out.println("Filter " + n);
        Link[][] linkArray = this.getFilters().get(n);
        int n2 = linkArray.length;
        for (int i = 0; i < n2; ++i) {
            Link[] linkArray2;
            for (Link link : linkArray2 = linkArray[i]) {
                System.out.print(link.getID() + " ");
            }
            System.out.println();
        }
    }

    private int getFilterLinkCount() {
        return this.filterHeight * this.filterWidth * this.filters.size();
    }

    Link createFilterLink() {
        Link link = this.link.clone();
        link.randomize();
        return link;
    }

    protected Link getFilterLink(Neuron neuron, Link link) {
        return link.clone();
    }

    protected void createFilter() {
        Link[][] linkArray = new Link[this.filterHeight][this.filterWidth];
        for (int i = 0; i < this.filterHeight; ++i) {
            for (int j = 0; j < this.filterWidth; ++j) {
                linkArray[i][j] = this.createFilterLink();
            }
        }
        this.filters.add(linkArray);
    }
}

