/*
 * Decompiled with CFR 0.152.
 */
package boone.structure;

import boone.map.Function;
import org.ujmp.core.Matrix;

public class CompiledNeuralNet {
    public Matrix[] neuronMatrices;
    public Matrix[] linkMatrices;
    protected Function[] neuronFunctions;
    protected double[] neuronBias;
    protected int numberOfLayers;

    public int getHiddenNeuronCount() {
        int n = 0;
        for (int i = 1; i < this.neuronMatrices.length - 1; ++i) {
            n = (int)((long)n + this.neuronMatrices[i].getRowCount());
        }
        return n;
    }

    public int getInputNeuronCount() {
        return (int)this.neuronMatrices[0].getRowCount();
    }

    public int getLinkCount() {
        int n = 0;
        for (int i = 0; i < this.neuronMatrices.length - 1; ++i) {
            Matrix matrix = this.linkMatrices[i];
            int n2 = 0;
            while ((long)n2 < matrix.getRowCount()) {
                int n3 = 0;
                while ((long)n3 < matrix.getColumnCount()) {
                    if (matrix.getAsInt(new long[]{n2, n3}) != 0) {
                        ++n;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return n;
    }

    public int getNeuronCount() {
        int n = 0;
        for (int i = 0; i < this.neuronMatrices.length; ++i) {
            n = (int)((long)n + this.neuronMatrices[i].getRowCount());
        }
        return n;
    }

    public double[] getOutput() {
        double[] dArray = new double[(int)this.neuronMatrices[this.numberOfLayers - 1].getRowCount()];
        for (int i = 0; i < (int)this.neuronMatrices[this.numberOfLayers - 1].getRowCount(); ++i) {
            dArray[i] = this.neuronMatrices[this.numberOfLayers - 1].getAsDouble(new long[]{i, 0L});
        }
        return dArray;
    }

    public int getOutputNeuronCount() {
        return (int)this.neuronMatrices[this.numberOfLayers - 1].getRowCount();
    }

    public void innervate() {
        int n = 0;
        int n2 = 0;
        if (this.numberOfLayers == 1) {
            int n3;
            for (n3 = 0; n3 < (int)this.neuronMatrices[n].getRowCount(); ++n3) {
                this.neuronMatrices[n].plus(this.neuronBias[n3 + n2]);
            }
            this.neuronMatrices[0] = this.linkMatrices[0].times(this.neuronMatrices[0]);
            for (n3 = 0; n3 < (int)this.neuronMatrices[n].getRowCount(); ++n3) {
                this.neuronMatrices[n].setAsDouble(this.neuronFunctions[n3 + n2].map(this.neuronMatrices[n].getAsDouble(new long[]{n3, 0L})), new long[]{n3, 0L});
            }
        } else {
            int n4;
            for (n4 = 0; n4 < (int)this.neuronMatrices[n].getRowCount(); ++n4) {
                this.neuronMatrices[n].setAsDouble(this.neuronFunctions[n4].map(this.neuronMatrices[n].getAsDouble(new long[]{n4, 0L})), new long[]{n4, 0L});
            }
            while (n < this.numberOfLayers - 1) {
                n2 += (int)this.neuronMatrices[n].getRowCount();
                this.neuronMatrices[n + 1] = this.linkMatrices[n].mtimes(this.neuronMatrices[n]);
                ++n;
                for (n4 = 0; n4 < (int)this.neuronMatrices[n].getRowCount(); ++n4) {
                    this.neuronMatrices[n].setAsDouble(this.neuronMatrices[n].getAsDouble(new long[]{n4, 0L}) + this.neuronBias[n4 + n2], new long[]{n4, 0L});
                    this.neuronMatrices[n].setAsDouble(this.neuronFunctions[n4 + n2].map(this.neuronMatrices[n].getAsDouble(new long[]{n4, 0L})), new long[]{n4, 0L});
                }
            }
        }
    }

    public void setInput(double[] dArray) {
        for (int i = 0; i < (int)this.neuronMatrices[0].getRowCount(); ++i) {
            this.neuronMatrices[0].setAsDouble(this.neuronMatrices[0].getAsDouble(new long[]{i, 0L}) + dArray[i] + this.neuronBias[i], new long[]{i, 0L});
        }
    }
}

