/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.Link;
import boone.Neuron;
import boone.map.Function;
import boone.spike.NeuronPotential;
import boone.spike.Spike;
import boone.spike.SpikeEvent;
import boone.spike.SpikeEventBuffer;
import boone.spike.SpikeEventQueue;
import boone.spike.SpikeSet;
import boone.util.Common;
import boone.util.RootSolver;
import boone.util.Xml;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jdom2.Element;

public class SpikingNeuron
extends Neuron {
    private SpikeEventBuffer buffer;
    private SpikeEventQueue emitted = new SpikeEventQueue();
    private SpikeEventQueue received = new SpikeEventQueue();
    private double threshold;
    private double refractoryPeriod;
    protected NeuronPotential neuronPotential = new NeuronPotential(this.emitted, this.received);
    private SpikeEvent predicted;
    private SpikeEvent lastSpike;
    private HashMap<Link, Double> lookAheadTimes;
    protected double maxLookAhead;
    private double minContribution = 1.0E-4;
    private List<Double> recorder;
    private double recStart;
    private double recStop;
    private final RootSolver rootSolver = new RootSolver();

    public SpikingNeuron() {
        this.setActivationFn(new Spike());
        this.threshold = 15.0;
    }

    public SpikingNeuron(boolean bl, boolean bl2, boolean bl3) {
        super(bl, bl2, bl3);
        this.setActivationFn(new Spike());
        this.threshold = 15.0;
    }

    @Override
    public SpikingNeuron clone() {
        SpikingNeuron spikingNeuron = (SpikingNeuron)super.clone();
        spikingNeuron.emitted = new SpikeEventQueue();
        spikingNeuron.received = new SpikeEventQueue();
        spikingNeuron.neuronPotential = new NeuronPotential(spikingNeuron.emitted, spikingNeuron.received);
        return spikingNeuron;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(double d) {
        this.threshold = d;
    }

    @Override
    public void randomize() {
        super.randomize();
        this.setThreshold(Common.getRandom(0.0, 30.0));
    }

    @Override
    public void randomize(double d, double d2) {
        super.randomize(d, d2);
        this.setThreshold(Common.getRandom(d, d2));
    }

    public void fire(double d) {
        this.buffer.add(new SpikeEvent(d, this, this, this.getActivationFn(), 0));
    }

    @Override
    public void calculate() {
        double d;
        SpikeEvent spikeEvent = this.buffer.getPreviousHead();
        double d2 = spikeEvent.getTime();
        if (this.lookAheadTimes == null) {
            this.lookAheadTimes = new HashMap();
            this.calcPSPQueueHorizon();
        }
        if ((d = spikeEvent.getType() == 0 ? d2 + this.refractoryPeriod : d2 + this.lookAheadTimes.get(spikeEvent.getOrigin())) > this.maxLookAhead) {
            this.maxLookAhead = d;
        }
        this.received.update(d2);
        this.emitted.update(d2);
        this.process(spikeEvent, this.maxLookAhead);
        this.buffer.setPreviousHead(null);
    }

    public void process(SpikeEvent spikeEvent, double d) {
        double d2 = spikeEvent.getTime();
        if (spikeEvent.getType() == 0) {
            this.lastSpike = spikeEvent;
            this.emitted.clear();
            this.emitted.add(spikeEvent);
            this.predicted = null;
            if (d2 >= this.recStart && d2 < this.recStop) {
                this.recorder.add(d2);
            }
            for (Link link : this.getLinks()) {
                if (!link.isOutputOf(this)) continue;
                link.setValue(d2);
                link.calculate();
            }
        } else if (spikeEvent.getType() == 1) {
            if (this.lastSpike != null && spikeEvent.getTime() - this.lastSpike.getTime() <= this.lastSpike.getFunction().getMaxValue()) {
                return;
            }
            if (this.predicted != null && d2 == this.predicted.getTime()) {
                return;
            }
            this.received.add(spikeEvent);
        }
        double d3 = this.rootSolver.findRoot(new Function.Scaled(1.0, -this.threshold, this.neuronPotential), d2, d);
        if (this.predicted != null) {
            this.buffer.remove(this.predicted);
            this.predicted = null;
        }
        if (!Double.isNaN(d3)) {
            this.predicted = new SpikeEvent(d3, this, this, this.getActivationFn(), 0);
            this.buffer.add(this.predicted);
        }
    }

    public void record(SpikeSet spikeSet, double d, double d2) {
        List<List<Double>> list = spikeSet.getOutputs();
        if ((long)list.size() <= this.getID()) {
            int n = list.size();
            while ((long)n <= this.getID()) {
                list.add(null);
                ++n;
            }
        }
        if (list.get((int)this.getID()) == null) {
            list.set((int)this.getID(), new ArrayList());
        }
        this.recorder = list.get((int)this.getID());
        this.recStart = d;
        this.recStop = d2;
    }

    public void recordStart(SpikeSet spikeSet) {
        this.record(spikeSet, 0.0, Double.MAX_VALUE);
    }

    public void recordStop() {
        this.recStop = 0.0;
    }

    @Override
    public void reset() {
        super.reset();
        this.maxLookAhead = 0.0;
        this.received.clear();
        this.emitted.clear();
        this.predicted = null;
        this.lastSpike = null;
        this.lookAheadTimes = null;
    }

    public void setBuffer(SpikeEventBuffer spikeEventBuffer) {
        this.buffer = spikeEventBuffer;
    }

    @Override
    public void setActivationFn(Function function) {
        super.setActivationFn(function);
        this.calcSpikeQueueHorizon();
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        this.threshold = Xml.getProperty(element, "threshold", this.threshold);
        this.minContribution = Xml.getProperty(element, "minContribution", this.minContribution);
        this.refractoryPeriod = this.rootSolver.calcLimit(this.activationFn, 0, this.minContribution);
        this.emitted.setHorizon(this.refractoryPeriod);
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("threshold", String.valueOf(this.threshold));
        element2.setAttribute("minContribution", String.valueOf(this.minContribution));
        return element2;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private void calcPSPQueueHorizon() {
        double d = 0.0;
        for (int i = 0; i < this.getLinkCount(); ++i) {
            double d2 = this.rootSolver.calcLimit(this.getLink(i).getActivationFn(), 1, this.minContribution);
            this.lookAheadTimes.put(this.getLink(i), d2);
            d = d2 > d ? d2 : d;
        }
        if (d > 0.0) {
            this.received.setHorizon(d);
        }
    }

    private void calcSpikeQueueHorizon() {
        this.refractoryPeriod = this.rootSolver.calcLimit(this.getActivationFn(), 0, this.minContribution);
        this.emitted.setHorizon(this.refractoryPeriod);
    }
}

