/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.BrainPart;
import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.io.IOFilter;
import boone.spike.SpikeEvent;
import boone.spike.SpikeEventBuffer;
import boone.spike.SpikeSet;
import boone.spike.SpikingLink;
import boone.spike.SpikingNeuron;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jdom2.Element;

public class SpikingNeuralNet
extends NeuralNet {
    private SpikeEventBuffer buffer = new SpikeEventBuffer();
    private Scheduler scheduler;
    private boolean realMode;
    private long realTime;
    private boolean schedulerActive;

    public SpikingNeuralNet() {
    }

    private SpikingNeuralNet(NeuralNet neuralNet) {
        int n;
        this.trainer = neuralNet.getTrainer();
        if (this.trainer != null) {
            this.trainer.setNetwork(this);
        }
        this.maxCycles = neuralNet.getMaxCycles();
        for (n = 0; n < neuralNet.getNeuronCount(); ++n) {
            this.addNeuron(neuralNet.getNeuron(n));
        }
        for (n = 0; n < neuralNet.getLinkCount(); ++n) {
            this.addLink(neuralNet.getLink(n));
        }
        this.props = neuralNet.props;
    }

    @Override
    public void innervate() {
        this.innervate(Double.POSITIVE_INFINITY);
    }

    public void innervate(double d) {
        this.stop();
        for (int i = 0; i < this.getNeuronCount(); ++i) {
            this.getNeuron(i).reset();
        }
        this.realTime = 0L;
        this.scheduler = new Scheduler(d);
        this.schedulerActive = true;
        this.scheduler.start();
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.interrupt();
            this.scheduler = null;
            this.schedulerActive = false;
        }
    }

    public void resume() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler(Double.MAX_VALUE);
            this.scheduler.start();
        }
    }

    public boolean isActive() {
        return this.schedulerActive;
    }

    public boolean hasMoreSpikes() {
        return !this.buffer.isEmpty();
    }

    public double getLatestSpikeTime() {
        return this.buffer.getLatestTime();
    }

    public void setInput(SpikeSet spikeSet) {
        this.buffer.clear();
        for (Neuron neuron : this.inputNeurons) {
            List<Double> list = spikeSet.getInputSpikes(neuron);
            if (list == null) continue;
            for (double d : list) {
                ((SpikingNeuron)neuron).fire(d);
            }
        }
    }

    public boolean isRealTimeMode() {
        return this.realMode;
    }

    public void setRealTimeMode(boolean bl) {
        this.realMode = bl;
    }

    @Override
    public void addNeuron(Neuron neuron) {
        super.addNeuron(neuron);
        ((SpikingNeuron)neuron).setBuffer(this.buffer);
    }

    @Override
    public void replaceNeuron(Neuron neuron, Neuron neuron2) {
        super.replaceNeuron(neuron, neuron2);
        ((SpikingNeuron)neuron).setBuffer(null);
        ((SpikingNeuron)neuron2).setBuffer(this.buffer);
    }

    @Override
    public boolean removeNeuron(Neuron neuron) {
        boolean bl = super.removeNeuron(neuron);
        ((SpikingNeuron)neuron).setBuffer(null);
        return bl;
    }

    @Override
    public void addLink(Link link) {
        super.addLink(link);
        ((SpikingLink)link).setBuffer(this.buffer);
    }

    @Override
    public void replaceLink(Link link, Link link2) {
        super.replaceLink(link, link2);
        ((SpikingLink)link).setBuffer(null);
        ((SpikingLink)link2).setBuffer(this.buffer);
    }

    @Override
    public boolean removeLink(Link link) {
        ((SpikingLink)link).setBuffer(null);
        return super.removeLink(link);
    }

    public static SpikingNeuralNet load(File file, IOFilter iOFilter) throws IOException {
        NeuralNet neuralNet = NeuralNet.load(file, iOFilter);
        return new SpikingNeuralNet(neuralNet);
    }

    @Override
    public void fromXML(Element element) {
        BrainPart brainPart;
        int n;
        super.fromXML(element);
        for (n = 0; n < this.getNeuronCount(); ++n) {
            brainPart = (SpikingNeuron)this.getNeuron(n);
            ((SpikingNeuron)brainPart).setBuffer(this.buffer);
        }
        for (n = 0; n < this.getLinkCount(); ++n) {
            brainPart = (SpikingLink)this.getLink(n);
            ((SpikingLink)brainPart).setBuffer(this.buffer);
        }
    }

    private class Scheduler
    extends Thread {
        private double timeLimit;

        public Scheduler(double d) {
            this.timeLimit = d;
        }

        @Override
        public void run() {
            if (SpikingNeuralNet.this.isRealTimeMode()) {
                this.doRealTime();
            } else {
                this.doSimTime();
            }
            SpikingNeuralNet.this.schedulerActive = false;
        }

        private void doSimTime() {
            try {
                while (true) {
                    SpikeEvent spikeEvent;
                    if ((spikeEvent = (SpikeEvent)SpikingNeuralNet.this.buffer.take()).getTime() > this.timeLimit) {
                        SpikingNeuralNet.this.buffer.add(spikeEvent);
                        return;
                    }
                    SpikingNeuralNet.this.buffer.setPreviousHead(spikeEvent);
                    spikeEvent.getDestination().calculate();
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRealTime() {
            long l = System.currentTimeMillis() - SpikingNeuralNet.this.realTime;
            try {
                while (true) {
                    SpikingNeuralNet.this.realTime = System.currentTimeMillis() - l;
                    SpikeEvent spikeEvent = (SpikeEvent)SpikingNeuralNet.this.buffer.poll((long)(this.timeLimit - (double)SpikingNeuralNet.this.realTime), TimeUnit.MILLISECONDS);
                    if (spikeEvent == null) {
                        return;
                    }
                    SpikingNeuralNet.this.realTime = System.currentTimeMillis() - l;
                    long l2 = (long)(spikeEvent.getTime() - (double)SpikingNeuralNet.this.realTime);
                    while (l2 > 0L) {
                        SpikingNeuralNet.this.buffer.add(spikeEvent);
                        SpikeEventBuffer spikeEventBuffer = SpikingNeuralNet.this.buffer;
                        synchronized (spikeEventBuffer) {
                            SpikingNeuralNet.this.buffer.wait(l2);
                        }
                        spikeEvent = (SpikeEvent)SpikingNeuralNet.this.buffer.take();
                        SpikingNeuralNet.this.realTime = System.currentTimeMillis() - l;
                        l2 = (long)spikeEvent.getTime() - SpikingNeuralNet.this.realTime;
                    }
                    if (spikeEvent.getTime() > this.timeLimit) {
                        SpikingNeuralNet.this.buffer.add(spikeEvent);
                        return;
                    }
                    SpikingNeuralNet.this.buffer.setPreviousHead(spikeEvent);
                    spikeEvent.getDestination().calculate();
                }
            }
            catch (InterruptedException interruptedException) {
                SpikingNeuralNet.this.realTime = System.nanoTime() - l;
                return;
            }
        }
    }
}

