/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.map.Function;
import boone.spike.PostsynapticPotential;
import boone.spike.SpikeEvent;
import boone.spike.SpikeEventBuffer;
import boone.util.Common;
import boone.util.Xml;
import org.jdom2.Element;

public class SpikingLink
extends Link {
    private SpikeEventBuffer buffer;
    private double delay;

    public SpikingLink() {
        this.setWeight(1.0);
        this.setActivationFn(new PostsynapticPotential());
    }

    public SpikingLink(Neuron neuron, Neuron neuron2, double d) {
        super(neuron, neuron2, d);
        this.setActivationFn(new PostsynapticPotential());
    }

    @Override
    public SpikingLink clone() {
        return (SpikingLink)super.clone();
    }

    @Override
    public void calculate() {
        SpikeEvent spikeEvent = new SpikeEvent(this.value + this.delay, this, this.getSink(), new Function.Scaled(this.getWeight(), 0.0, this.getActivationFn()), 1);
        this.buffer.add(spikeEvent);
    }

    @Override
    public void randomize() {
        this.weight = 1.0;
        this.setDelay(Common.getRandom(0.0, 5.0));
    }

    @Override
    public void randomize(double d, double d2) {
        this.weight = 1.0;
        d = Common.limitToRange(d, 0.0, d);
        d2 = Common.limitToRange(d2, d, d2);
        this.setDelay(Common.getRandom(d, d2));
    }

    @Override
    public void replaceFrom(Link link) {
        super.replaceFrom(link);
        ((SpikingLink)link).setBuffer(null);
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double d) {
        this.delay = d;
    }

    public void setBuffer(SpikeEventBuffer spikeEventBuffer) {
        this.buffer = spikeEventBuffer;
    }

    @Override
    public void fromXML(Element element, NeuralNet neuralNet) {
        super.fromXML(element, neuralNet);
        this.delay = Xml.getProperty(element, "delay", this.delay);
        this.activationFn = (Function)Xml.getStorable(element, "activationFn");
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("delay", String.valueOf(this.delay));
        this.activationFn.toXML(element2);
        return element2;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.getActivationFn().getClass().getSimpleName() + String.format(" %.2f", this.delay);
    }
}

