/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.spike.SpikeEvent;
import java.util.Arrays;
import java.util.concurrent.PriorityBlockingQueue;

public class SpikeEventQueue
extends PriorityBlockingQueue<SpikeEvent> {
    private double horizon;

    public SpikeEventQueue() {
        this.setHorizon(Double.POSITIVE_INFINITY);
    }

    public SpikeEventQueue(double d) {
        this.setHorizon(d);
    }

    public void update(double d) {
        SpikeEvent spikeEvent = (SpikeEvent)this.peek();
        while (spikeEvent != null && d - spikeEvent.getTime() > this.getHorizon()) {
            this.remove();
            spikeEvent = (SpikeEvent)this.peek();
        }
    }

    public double getHorizon() {
        return this.horizon;
    }

    public void setHorizon(double d) {
        this.horizon = d;
    }

    @Override
    public String toString() {
        Object[] objectArray = new SpikeEvent[this.size()];
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ");
        objectArray = this.toArray(objectArray);
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            stringBuilder.append(object + ", ");
        }
        if (objectArray.length != 0) {
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

