/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.map.Function;
import boone.util.Xml;
import org.jdom2.Element;

public class Spike
extends Function {
    private double abs = 110.0;
    private double absDur = 2.0;
    private double rel = 55.0;
    private double relDur = 0.5;
    private double durUp = 1.0E-8;
    private double durDown = 1.0E-8;
    private double slopeUp = this.abs / this.durUp;
    private double slopeDown = -((this.abs + this.rel) / this.durDown);

    public Spike() {
    }

    public Spike(double d, double d2, double d3, double d4) {
        this.abs = d;
        this.absDur = d2;
        this.rel = d3;
        this.relDur = d4;
    }

    public double getAbsDur() {
        return this.absDur;
    }

    public void setAbsDur(double d) {
        this.absDur = d;
    }

    public double getRelDur() {
        return this.relDur;
    }

    public void setRelDur(double d) {
        this.relDur = d;
    }

    @Override
    public double map(double d) {
        if (d < this.durUp) {
            return this.slopeUp * d;
        }
        if (d >= this.absDur && d <= this.absDur + this.durDown) {
            return this.abs + this.slopeDown * (d - this.absDur);
        }
        if (this.relDur == 0.0) {
            return this.abs * this.heaviside(this.absDur - d + this.durDown);
        }
        return this.abs * this.heaviside(this.absDur - d + this.durDown) - this.rel * Math.exp(-(d - this.absDur - this.durDown) / this.relDur) * this.heaviside(d - this.absDur - this.durDown);
    }

    @Override
    public double mapDerivative(double d) {
        if (d < this.durUp) {
            return this.slopeUp;
        }
        if (d >= this.absDur && d < this.absDur + this.durDown) {
            return this.slopeDown;
        }
        if (this.relDur == 0.0) {
            return 0.0;
        }
        return this.rel / this.relDur * Math.exp(-((d - this.absDur - this.durDown) / this.relDur)) * this.heaviside(d - this.absDur - this.durDown);
    }

    @Override
    public double getMinValue() {
        return Double.MIN_VALUE;
    }

    @Override
    public double getMaxValue() {
        return this.durUp + this.absDur + this.durDown;
    }

    @Override
    public void fromXML(Element element) {
        this.abs = Xml.getProperty(element, "abs", this.abs);
        this.absDur = Xml.getProperty(element, "absDur", this.absDur);
        this.rel = Xml.getProperty(element, "rel", this.rel);
        this.relDur = Xml.getProperty(element, "relDur", this.relDur);
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("abs", String.valueOf(this.abs));
        element2.setAttribute("absDur", String.valueOf(this.absDur));
        element2.setAttribute("rel", String.valueOf(this.rel));
        element2.setAttribute("relDur", String.valueOf(this.relDur));
        return element2;
    }

    private double heaviside(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return 1.0;
    }

    @Override
    public Spike clone() {
        return (Spike)super.clone();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Spike) {
            Spike spike = (Spike)object;
            return spike.abs == this.abs && spike.absDur == this.absDur && spike.rel == this.rel && spike.relDur == this.relDur;
        }
        return false;
    }
}

