/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.map.Function;
import boone.util.Xml;
import org.jdom2.Element;

public class PostsynapticPotential
extends Function {
    private double alpha = 1.5;
    private double lambda = 0.7;
    private double mu = 0.8;
    private double scale = 100.0;

    public PostsynapticPotential() {
    }

    public PostsynapticPotential(double d, double d2, double d3) {
        this.alpha = d;
        this.lambda = d2;
        this.mu = d3;
    }

    @Override
    public double map(double d) {
        return this.scale * (this.alpha * (Math.exp(-(this.lambda * d)) - Math.exp(-(this.mu * d))));
    }

    @Override
    public double mapDerivative(double d) {
        return this.scale * this.alpha * (-this.lambda * Math.exp(-(this.lambda * d)) + this.mu * Math.exp(-(this.mu * d)));
    }

    @Override
    public double getMinValue() {
        return Double.MIN_VALUE;
    }

    @Override
    public double getMaxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public void fromXML(Element element) {
        this.alpha = Xml.getProperty(element, "alpha", this.alpha);
        this.lambda = Xml.getProperty(element, "lambda", this.lambda);
        this.mu = Xml.getProperty(element, "mu", this.mu);
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("alpha", String.valueOf(this.alpha));
        element2.setAttribute("lambda", String.valueOf(this.lambda));
        element2.setAttribute("mu", String.valueOf(this.mu));
        return element2;
    }

    @Override
    public PostsynapticPotential clone() {
        return (PostsynapticPotential)super.clone();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof PostsynapticPotential) {
            PostsynapticPotential postsynapticPotential = (PostsynapticPotential)object;
            return postsynapticPotential.alpha == this.alpha && postsynapticPotential.lambda == this.lambda && postsynapticPotential.mu == this.mu;
        }
        return false;
    }
}

