/*
 * Decompiled with CFR 0.152.
 */
package boone.spike;

import boone.map.Function;
import boone.spike.SpikeEvent;
import boone.spike.SpikeEventQueue;

public class NeuronPotential
extends Function {
    private SpikeEventQueue emitted_;
    private SpikeEventQueue received_;

    public NeuronPotential(SpikeEventQueue spikeEventQueue, SpikeEventQueue spikeEventQueue2) {
        this.emitted_ = spikeEventQueue;
        this.received_ = spikeEventQueue2;
    }

    @Override
    public NeuronPotential clone() {
        NeuronPotential neuronPotential = (NeuronPotential)super.clone();
        neuronPotential.emitted_ = null;
        neuronPotential.received_ = null;
        return neuronPotential;
    }

    @Override
    public double map(double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        for (SpikeEvent spikeEvent : this.received_) {
            if (!(spikeEvent.getTime() <= d)) continue;
            d2 += spikeEvent.getFunction().map(d - spikeEvent.getTime());
        }
        for (SpikeEvent spikeEvent : this.emitted_) {
            if (!(spikeEvent.getTime() <= d)) continue;
            d3 += spikeEvent.getFunction().map(d - spikeEvent.getTime());
        }
        return d3 + d2;
    }

    @Override
    public double mapDerivative(double d) {
        double d2 = 0.0;
        for (SpikeEvent spikeEvent : this.received_) {
            if (!(spikeEvent.getTime() <= d)) continue;
            d2 += spikeEvent.getFunction().mapDerivative(d - spikeEvent.getTime());
        }
        for (SpikeEvent spikeEvent : this.emitted_) {
            if (!(spikeEvent.getTime() <= d)) continue;
            d2 += spikeEvent.getFunction().mapDerivative(d - spikeEvent.getTime());
        }
        return d2;
    }

    @Override
    public double mapSecondDerivative(double d) {
        double d2 = 0.0;
        for (SpikeEvent spikeEvent : this.received_) {
            if (!(spikeEvent.getTime() <= d)) continue;
            d2 += spikeEvent.getFunction().mapSecondDerivative(d - spikeEvent.getTime());
        }
        for (SpikeEvent spikeEvent : this.emitted_) {
            if (!(spikeEvent.getTime() <= d)) continue;
            d2 += spikeEvent.getFunction().mapSecondDerivative(d - spikeEvent.getTime());
        }
        return d2;
    }

    @Override
    public double getMinValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getMaxValue() {
        return Double.POSITIVE_INFINITY;
    }
}

