/*
 * Decompiled with CFR 0.152.
 */
package boone.neurons;

import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.io.Storable;
import boone.util.Common;
import java.util.ArrayList;
import java.util.Random;
import org.jdom2.Element;

public class NeuronList
extends ArrayList<Neuron>
implements Storable,
Cloneable {
    public NeuralNet net;

    public NeuronList() {
    }

    public NeuronList(int n, Neuron neuron) {
        super(n);
        for (int i = 0; i < n; ++i) {
            this.add(neuron.clone());
        }
    }

    public NeuronList(NeuralNet neuralNet) {
        super(neuralNet.getNeuronCount());
        this.net = neuralNet;
    }

    public boolean sortTopological() {
        NeuronList neuronList = new NeuronList();
        for (Neuron neuron : this) {
            neuron.setLayer(neuron.getInputLinkCount());
            if (neuron.getLayer() != 0) continue;
            if (!neuron.isInputNeuron()) {
                System.out.println("Warning! " + neuron + " has zero input links.");
            }
            neuronList.add(neuron);
        }
        NeuronList neuronList2 = new NeuronList();
        while (neuronList.size() > 0) {
            Neuron neuron;
            neuron = (Neuron)neuronList.remove(0);
            neuronList2.add(neuron);
            for (Link link : neuron.getLinks()) {
                if (!link.isOutputOf(neuron)) continue;
                Neuron neuron2 = link.getSink();
                neuron2.setLayer(neuron2.getLayer() - 1);
                if (neuron2.getLayer() != 0) continue;
                neuron2.setLayer(neuron.getLayer() + 1);
                neuronList.add(neuron2);
            }
        }
        if (neuronList2.size() == this.size()) {
            this.clear();
            this.addAll(neuronList2);
            return true;
        }
        return false;
    }

    public void sortRandom() {
        Random random = Common.getRandom();
        int n = this.size();
        int n2 = Math.max(n / 4, 1);
        for (int i = 0; i < n2; ++i) {
            Common.swap(this, random.nextInt(n), random.nextInt(n));
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Neuron neuron : this) {
            stringBuilder.append(neuron).append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public void fromXML(Element element) {
    }

    @Override
    public Element toXML(Element element) {
        return null;
    }
}

