/*
 * Decompiled with CFR 0.152.
 */
package boone.map;

import boone.NeuralNet;
import boone.Neuron;
import boone.io.Storable;
import boone.util.Xml;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public abstract class Topology
implements Cloneable,
Storable {
    protected static final int EMPTY = -1;
    protected NeuralNet net;
    private List<Neuron> neighbors = new ArrayList<Neuron>();
    private Neuron lastNeuron;
    private int lastRadius;

    public Topology clone() {
        try {
            return (Topology)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public NeuralNet getNet() {
        return this.net;
    }

    public void setNet(NeuralNet neuralNet) {
        this.net = neuralNet;
    }

    public List<Neuron> getNeighbors(Neuron neuron, int n) {
        if (neuron == this.lastNeuron && n == this.lastRadius) {
            return this.neighbors;
        }
        this.lastNeuron = neuron;
        this.lastRadius = n;
        this.neighbors.clear();
        this.neighbors.add(neuron);
        if (n <= 0) {
            return this.neighbors;
        }
        this.clearMap();
        this.setMapValue((int)neuron.getID(), 0);
        for (Neuron neuron2 : this.neighbors) {
            this.searchNeighbors((int)neuron2.getID(), n);
        }
        return this.neighbors;
    }

    public abstract boolean arrangeNeurons();

    protected void addNeighbor(int n) {
        this.neighbors.add(this.net.getOutputNeuron(n));
    }

    public abstract int[] getNeurons();

    public abstract double[] getSizes();

    protected abstract void setMapValue(int var1, int var2);

    public abstract int getTotalNeurons();

    protected abstract void clearMap();

    protected abstract void searchNeighbors(int var1, int var2);

    @Override
    public Element toXML(Element element) {
        return Xml.addStorable(element, "topology", this);
    }
}

