/*
 * Decompiled with CFR 0.152.
 */
package boone.map;

import boone.Neuron;
import boone.map.Topology;
import boone.util.Xml;
import java.util.Arrays;
import org.jdom2.Element;

public class HexagonTopology
extends Topology {
    private int[][] map;

    public HexagonTopology(int n, int n2) {
        this.map = new int[n][n2];
    }

    @Override
    public HexagonTopology clone() {
        return (HexagonTopology)super.clone();
    }

    @Override
    public int[] getNeurons() {
        return new int[]{this.map.length, this.map[0].length};
    }

    @Override
    public double[] getSizes() {
        double[] dArray = new double[2];
        Neuron neuron = this.net.getOutputNeuron(this.getID(0, 0));
        Neuron neuron2 = this.net.getOutputNeuron(this.getID(1, this.map[0].length - 1));
        dArray[0] = neuron.getPosition().distanceTo(neuron2.getPosition());
        Neuron neuron3 = this.net.getOutputNeuron(this.getID(this.map.length - 1, 0));
        dArray[1] = neuron.getPosition().distanceTo(neuron3.getPosition());
        return dArray;
    }

    @Override
    public boolean arrangeNeurons() {
        if (this.net.getOutputNeuronCount() != this.getTotalNeurons()) {
            return false;
        }
        float f = (float)(Math.sqrt(3.0) / 2.0);
        int n = this.net.getOutputNeuronCount();
        for (int i = 0; i < n; ++i) {
            Neuron neuron = this.net.getOutputNeuron(i);
            int n2 = i / this.map[0].length;
            int n3 = i % this.map[0].length;
            double d = n2 % 2 == 1 ? 0.5 : 0.0;
            neuron.getPosition().set((float)((double)n3 + d), (float)n2 * f);
            neuron.setID(i);
        }
        return true;
    }

    @Override
    protected void setMapValue(int n, int n2) {
        this.map[n / this.map[0].length][n % this.map[0].length] = n2;
    }

    @Override
    public int getTotalNeurons() {
        return this.map.length * this.map[0].length;
    }

    @Override
    protected void clearMap() {
        for (int[] nArray : this.map) {
            Arrays.fill(nArray, -1);
        }
    }

    @Override
    protected void searchNeighbors(int n, int n2) {
        int n3 = n / this.map[0].length;
        int n4 = n % this.map[0].length;
        int n5 = this.map[n3][n4];
        if (n5 == n2) {
            return;
        }
        this.right(n3, n4, ++n5);
        this.upRight(n3, n4, n5);
        this.upLeft(n3, n4, n5);
        this.left(n3, n4, n5);
        this.downLeft(n3, n4, n5);
        this.downRight(n3, n4, n5);
    }

    @Override
    public void fromXML(Element element) {
        int n = Xml.getProperty(element, "HexRows", 0);
        int n2 = Xml.getProperty(element, "HexColumns", 0);
        this.map = new int[n][n2];
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = super.toXML(element);
        element2.setAttribute("Rows", String.valueOf(this.map.length));
        element2.setAttribute("Columns", String.valueOf(this.map[0].length));
        return element2;
    }

    public Neuron getRight(int n) {
        int n2 = n % this.map[0].length;
        if (++n2 < this.map[0].length) {
            return this.net.getOutputNeuron(n + 1);
        }
        return null;
    }

    public Neuron getLowerLeft(int n) {
        int n2 = n / this.map[0].length;
        int n3 = n % this.map[0].length;
        if (++n2 == this.map.length) {
            return null;
        }
        if ((n3 -= n2 % 2) >= 0) {
            return this.net.getOutputNeuron(this.getID(n2, n3));
        }
        return null;
    }

    public Neuron getLowerRight(int n) {
        int n2 = n / this.map[0].length;
        int n3 = n % this.map[0].length;
        n3 += n2 % 2;
        if (++n2 == this.map.length) {
            return null;
        }
        if (n3 < this.map[n2].length) {
            return this.net.getOutputNeuron(this.getID(n2, n3));
        }
        return null;
    }

    private void right(int n, int n2, int n3) {
        if (++n2 < this.map[n].length && this.map[n][n2] == -1) {
            this.map[n][n2] = n3;
            this.addNeighbor(this.getID(n, n2));
        }
    }

    private void upRight(int n, int n2, int n3) {
        n2 += n % 2;
        if (--n < 0) {
            return;
        }
        if (n2 < this.map[n].length && this.map[n][n2] == -1) {
            this.map[n][n2] = n3;
            this.addNeighbor(this.getID(n, n2));
        }
    }

    private void upLeft(int n, int n2, int n3) {
        if (--n < 0) {
            return;
        }
        if ((n2 -= n % 2) >= 0 && this.map[n][n2] == -1) {
            this.map[n][n2] = n3;
            this.addNeighbor(this.getID(n, n2));
        }
    }

    private void left(int n, int n2, int n3) {
        if (--n2 >= 0 && this.map[n][n2] == -1) {
            this.map[n][n2] = n3;
            this.addNeighbor(this.getID(n, n2));
        }
    }

    private void downLeft(int n, int n2, int n3) {
        if (++n == this.map.length) {
            return;
        }
        if ((n2 -= n % 2) >= 0 && this.map[n][n2] == -1) {
            this.map[n][n2] = n3;
            this.addNeighbor(this.getID(n, n2));
        }
    }

    private void downRight(int n, int n2, int n3) {
        n2 += n % 2;
        if (++n == this.map.length) {
            return;
        }
        if (n2 < this.map[n].length && this.map[n][n2] == -1) {
            this.map[n][n2] = n3;
            this.addNeighbor(this.getID(n, n2));
        }
    }

    private int getID(int n, int n2) {
        return n * this.map[0].length + n2;
    }
}

