/*
 * Decompiled with CFR 0.152.
 */
package boone.map;

import boone.Boone;
import boone.io.Storable;
import boone.util.CloneException;
import boone.util.Common;
import boone.util.Conversion;
import boone.util.ExceptionHandler;
import boone.util.Xml;
import org.jdom2.Element;

public abstract class Function
implements Cloneable,
Storable {
    public static Function create(String string) {
        try {
            return (Function)Boone.newInstance(string);
        }
        catch (Exception exception) {
            ExceptionHandler.handle(exception, "Function.create(\"" + string + "\")");
            return null;
        }
    }

    public void setParameters(Object object) {
    }

    public double map(double d) {
        throw new NotImplemented("Simple mapping is not implemented");
    }

    public double mapDerivative(double d) {
        throw new NotImplemented("Derivative is not implemented");
    }

    public double mapSecondDerivative(double d) {
        throw new NotImplemented("Second derivative is not implemented");
    }

    public abstract double getMinValue();

    public abstract double getMaxValue();

    public Function clone() {
        try {
            return (Function)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneException(cloneNotSupportedException);
        }
    }

    @Override
    public Element toXML(Element element) {
        return Xml.addStorable(element, "activationFn", this);
    }

    @Override
    public void fromXML(Element element) {
    }

    public static class SoftMax
    extends Function {
        static final Function exp = new Exponential();
        double[] values;

        @Override
        public void setParameters(Object object) {
            this.values = (double[])object;
        }

        @Override
        public double map(double d) {
            if (d < 0.0) {
                int n = Common.getMaxIndex(this.values);
                double d2 = this.values[n];
                double d3 = this.getDenominator(this.values, d2);
                for (int i = 0; i < this.values.length; ++i) {
                    this.values[i] = exp.map(this.values[i] - d2) / d3;
                }
                return d;
            }
            return 1.0 / this.getDenominator(this.values, this.values[(int)d]);
        }

        private double getDenominator(double[] dArray, double d) {
            double d2 = 0.0;
            for (double d3 : dArray) {
                d2 += exp.map(d3 - d);
            }
            return d2;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }
    }

    public static class NaturalSpline
    extends Function
    implements Spline {
        private double[] b;
        private double[] c;
        private double[] d;
        protected double[] data;

        public NaturalSpline() {
            this.data = new double[12];
            this.data[0] = 5.0;
            for (int i = 1; i < 12; ++i) {
                this.data[i] = 1.0 / (1.0 + Math.exp(6 - i));
            }
            this.calculateCoefficients();
        }

        public NaturalSpline(double[] dArray) {
            this.data = dArray;
            this.calculateCoefficients();
        }

        @Override
        public NaturalSpline clone() {
            NaturalSpline naturalSpline = (NaturalSpline)super.clone();
            naturalSpline.data = new double[this.data.length];
            System.arraycopy(this.data, 0, naturalSpline.data, 0, this.data.length);
            return naturalSpline;
        }

        @Override
        public double map(double d) {
            if (d < -this.data[0]) {
                return this.b[0] * d + this.data[1] - this.b[0] * -this.data[0];
            }
            if (d > this.data[0]) {
                double d2 = this.b[this.b.length - 1] + 2.0 * this.c[this.c.length - 1] + 3.0 * this.d[this.d.length - 1];
                return d2 * d + this.data[this.data.length - 1] - d2 * this.data[0];
            }
            int n = this.determineInterval(d, this.data[0], this.data.length - 1);
            double d3 = d - this.data[0] * (-1.0 + 2.0 / ((double)this.data.length - 2.0) * (double)(n - 1));
            return this.data[n] + this.b[n - 1] * d3 + this.c[n - 1] * d3 * d3 + this.d[n - 1] * d3 * d3 * d3;
        }

        @Override
        public double mapDerivative(double d) {
            if (d < -this.data[0]) {
                return this.b[0];
            }
            if (d > this.data[0]) {
                return this.b[this.b.length - 1] + 2.0 * this.c[this.c.length - 1] + 3.0 * this.d[this.d.length - 1];
            }
            int n = this.determineInterval(d, this.data[0], this.data.length - 1);
            double d2 = d - this.data[0] * (-1.0 + 2.0 / ((double)this.data.length - 2.0) * (double)(n - 1));
            return this.b[n - 1] + 2.0 * this.c[n - 1] * d2 + 3.0 * this.d[n - 1] * d2 * d2;
        }

        @Override
        public double getMinValue() {
            return -1.7976931348623157E308;
        }

        @Override
        public double getMaxValue() {
            return Double.MAX_VALUE;
        }

        private int determineInterval(double d, double d2, int n) {
            int n2;
            for (n2 = 1; n2 < n - 1; ++n2) {
                if (!(-d2 + (double)n2 * (2.0 / ((double)n - 1.0)) * d2 >= d)) continue;
                return n2;
            }
            return n2;
        }

        private void calculateCoefficients() {
            int n;
            this.b = new double[this.data.length - 1];
            this.c = new double[this.data.length - 1];
            this.d = new double[this.data.length - 1];
            double[] dArray = new double[this.data.length - 1];
            double[] dArray2 = new double[this.data.length - 1];
            double[] dArray3 = new double[this.data.length - 1];
            double[] dArray4 = new double[this.data.length - 1];
            for (n = 1; n < this.data.length - 1; ++n) {
                dArray[n] = this.data[0] * (2.0 / ((double)this.data.length - 2.0));
                dArray2[n] = (this.data[n + 1] - this.data[n]) / dArray[n];
            }
            dArray3[0] = dArray[2];
            dArray[0] = this.data[0] * (4.0 / ((double)this.data.length - 2.0));
            double d = this.data[0] * (2.0 / ((double)this.data.length - 2.0));
            double d2 = dArray[0];
            double d3 = dArray2[1];
            double d4 = dArray[2];
            double d5 = dArray2[2];
            dArray4[0] = ((d + 2.0 * d2) * d3 * d4 + d * d * d5) / d2;
            for (n = 1; n < this.data.length - 2; ++n) {
                d = -dArray[n + 1] / dArray3[n - 1];
                d2 = dArray4[n - 1];
                d3 = dArray[n];
                d4 = dArray2[n + 1];
                d5 = dArray[n + 1];
                double d6 = dArray2[n];
                dArray4[n] = d * d2 + 3.0 * (d3 * d4 + d5 * d6);
                dArray3[n] = d * dArray[n - 1] + 2.0 * (d3 + d5);
            }
            d = this.data[0] * (4.0 / ((double)this.data.length - 2.0));
            double d7 = dArray[this.data.length - 2];
            d2 = dArray2[this.data.length - 2];
            d3 = dArray[this.data.length - 3];
            d4 = dArray2[this.data.length - 3];
            dArray4[this.data.length - 2] = ((d7 + d + d) * d2 * d3 + d7 * d7 * d4) / d;
            d = -d / dArray3[this.data.length - 3];
            dArray3[this.data.length - 2] = (d + 1.0) * d3;
            this.b[this.data.length - 2] = (d * dArray4[this.data.length - 3] + dArray4[this.data.length - 2]) / dArray3[this.data.length - 2];
            for (n = this.data.length - 3; n >= 0; --n) {
                d2 = dArray4[n];
                d3 = dArray[n];
                d4 = this.b[n + 1];
                d5 = dArray3[n];
                this.b[n] = (d2 - d3 * d4) / d5;
            }
            for (n = 1; n < this.data.length - 1; ++n) {
                d7 = dArray2[n];
                double d8 = dArray[n];
                d2 = this.b[n - 1];
                d3 = this.b[n];
                double d9 = d2 + d3 - d7 - d7;
                this.c[n - 1] = (d7 - d2 - d9) / d8;
                this.d[n - 1] = d9 / (d8 * d8);
            }
        }

        @Override
        public double[] getData() {
            return this.data;
        }

        @Override
        public void setData(double[] dArray) {
            this.data = dArray;
            this.calculateCoefficients();
        }

        @Override
        public void fromXML(Element element) {
            this.data = Conversion.parseDoubleList(Xml.getProperty(element, "data", null));
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("data", Conversion.constructDoubleList(this.data));
        }
    }

    public static class CatmullRomSpline
    extends Function
    implements Spline {
        protected double[] data;

        public CatmullRomSpline() {
            this.data = new double[12];
            this.data[0] = 5.0;
            for (int i = 1; i < 12; ++i) {
                this.data[i] = 1.0 / (1.0 + Math.exp(6 - i));
            }
        }

        public CatmullRomSpline(double[] dArray) {
            this.data = dArray;
        }

        @Override
        public double map(double d) {
            int n = this.data.length;
            if (d < -this.data[0] + 2.0 / ((double)n - 2.0) * this.data[0]) {
                double d2 = (this.data[2] - this.data[1]) / (2.0 / ((double)n - 2.0) * this.data[0]);
                double d3 = this.data[1] - -this.data[0] * (this.data[2] - this.data[1]) / (2.0 / ((double)n - 2.0) * this.data[0]);
                return d2 * d + d3;
            }
            if (d > this.data[0] - 2.0 / ((double)n - 2.0) * this.data[0]) {
                double d4 = (this.data[n - 1] - this.data[n - 2]) / (2.0 / ((double)n - 2.0) * this.data[0]);
                double d5 = this.data[n - 1] - this.data[0] * (this.data[this.data.length - 1] - this.data[n - 2]) / (2.0 / ((double)n - 2.0) * this.data[0]);
                return d4 * d + d5;
            }
            int n2 = this.determineInterval(d, this.data[0], n - 1);
            double d6 = this.calculateDistanceRatio(d, this.data[0], n - 1, n2);
            return 0.5 * (((-d6 + 2.0) * d6 - 1.0) * d6 * this.data[n2 - 1] + ((3.0 * d6 - 5.0) * d6 * d6 + 2.0) * this.data[n2] + ((-3.0 * d6 + 4.0) * d6 + 1.0) * d6 * this.data[n2 + 1] + (d6 - 1.0) * d6 * d6 * this.data[n2 + 2]);
        }

        @Override
        public double mapDerivative(double d) {
            if (d < -this.data[0] + 2.0 / ((double)this.data.length - 2.0) * this.data[0]) {
                return (this.data[2] - this.data[1]) / (2.0 / ((double)this.data.length - 2.0) * this.data[0]);
            }
            if (d > this.data[0] - 2.0 / ((double)this.data.length - 2.0) * this.data[0]) {
                return (this.data[this.data.length - 1] - this.data[this.data.length - 2]) / (2.0 / ((double)this.data.length - 2.0) * this.data[0]);
            }
            int n = this.determineInterval(d, this.data[0], this.data.length - 1);
            double d2 = this.calculateDistanceRatio(d, this.data[0], this.data.length - 1, n);
            return 0.5 * (((-3.0 * d2 + 4.0) * d2 - 1.0) * this.data[n - 1] + (9.0 * d2 - 10.0) * d2 * this.data[n] + ((-9.0 * d2 + 8.0) * d2 + 1.0) * this.data[n + 1] + (3.0 * d2 - 2.0) * d2 * this.data[n + 2]);
        }

        @Override
        public double getMinValue() {
            return -1.7976931348623157E308;
        }

        @Override
        public double getMaxValue() {
            return Double.MAX_VALUE;
        }

        private int determineInterval(double d, double d2, int n) {
            int n2;
            for (n2 = 2; n2 < n - 2; ++n2) {
                if (!(-d2 + (double)n2 * (2.0 / ((double)n - 1.0)) * d2 >= d)) continue;
                return n2;
            }
            return n2;
        }

        private double calculateDistanceRatio(double d, double d2, int n, int n2) {
            return (d - d2 * (-1.0 + 2.0 / ((double)n - 1.0) * (double)(n2 - 1))) / (d2 * 2.0 / ((double)n - 1.0));
        }

        @Override
        public double[] getData() {
            return this.data;
        }

        @Override
        public void setData(double[] dArray) {
            this.data = dArray;
        }

        @Override
        public void fromXML(Element element) {
            this.data = Conversion.parseDoubleList(Xml.getNodeContent(element, "data"));
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("data", Conversion.constructDoubleList(this.data));
        }

        @Override
        public CatmullRomSpline clone() {
            CatmullRomSpline catmullRomSpline = (CatmullRomSpline)super.clone();
            catmullRomSpline.data = new double[this.data.length];
            System.arraycopy(this.data, 0, catmullRomSpline.data, 0, this.data.length);
            return catmullRomSpline;
        }
    }

    public static interface Spline {
        public double[] getData();

        public void setData(double[] var1);
    }

    public static class Clip
    extends Function {
        double lowBorder = 0.0;
        double highBorder = 1.0;

        public Clip() {
        }

        public Clip(double d, double d2) {
            if (d < d2) {
                this.lowBorder = d;
                this.highBorder = d2;
            } else {
                this.lowBorder = d2;
                this.highBorder = d;
            }
        }

        @Override
        public double map(double d) {
            return d < this.lowBorder ? this.lowBorder : (d > this.highBorder ? this.highBorder : d);
        }

        @Override
        public double getMinValue() {
            return this.lowBorder;
        }

        @Override
        public double getMaxValue() {
            return this.highBorder;
        }

        @Override
        public void fromXML(Element element) {
            this.lowBorder = Xml.getProperty(element, "lowBorder", this.lowBorder);
            this.highBorder = Xml.getProperty(element, "highBorder", this.highBorder);
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            element2.setAttribute("lowBorder", String.valueOf(this.lowBorder));
            return element2.setAttribute("highBorder", String.valueOf(this.highBorder));
        }
    }

    public static class TanH
    extends Function {
        static double cacheValue = 0.0;
        static double cacheResult = 0.0;

        @Override
        public double map(double d) {
            if (d != cacheValue) {
                cacheValue = d;
                double d2 = Math.exp(-2.0 * Math.abs(d));
                cacheResult = (1.0 - d2) / (1.0 + d2);
                if (d < 0.0) {
                    cacheResult = -cacheResult;
                }
            }
            return cacheResult;
        }

        @Override
        public double mapDerivative(double d) {
            double d2 = this.map(d);
            return 1.0 - d2 * d2;
        }

        @Override
        public double mapSecondDerivative(double d) {
            double d2 = this.map(d);
            return 2.0 * d2 * (d2 * d2 - 1.0);
        }

        @Override
        public double getMinValue() {
            return -1.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }
    }

    public static class Sinus
    extends Function {
        double factor = 0.1;

        public Sinus() {
        }

        public Sinus(double d) {
            this.factor = d;
        }

        @Override
        public double map(double d) {
            return Math.sin(this.factor * d);
        }

        @Override
        public double mapDerivative(double d) {
            return this.factor * Math.cos(this.factor * d);
        }

        @Override
        public double mapSecondDerivative(double d) {
            return this.factor * this.factor * -Math.sin(this.factor * d);
        }

        @Override
        public double getMinValue() {
            return -1.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }

        @Override
        public void fromXML(Element element) {
            this.factor = Xml.getProperty(element, "factor", this.factor);
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("factor", String.valueOf(this.factor));
        }
    }

    public static class SignumWithoutZero
    extends Function {
        @Override
        public double map(double d) {
            return d > 0.0 ? 1.0 : -1.0;
        }

        @Override
        public double getMinValue() {
            return -1.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }
    }

    public static class Signum
    extends Function {
        @Override
        public double map(double d) {
            return d > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : 0.0);
        }

        @Override
        public double getMinValue() {
            return -1.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }
    }

    public static class Sigmoid
    extends Function {
        static double cacheValue = 0.0;
        static double cacheResult = 0.5;

        @Override
        public double map(double d) {
            if (d != cacheValue) {
                cacheValue = d;
                cacheResult = 1.0 / (1.0 + Math.exp(-d));
            }
            return cacheResult;
        }

        @Override
        public double mapDerivative(double d) {
            double d2 = this.map(d);
            return d2 * (1.0 - d2);
        }

        @Override
        public double mapSecondDerivative(double d) {
            double d2 = this.map(d);
            return d2 * (1.0 - d2) * (2.0 * d2 - 1.0);
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }
    }

    public static class ReLU
    extends Function {
        @Override
        public double map(double d) {
            return d > 0.0 ? d : 0.0;
        }

        @Override
        public double mapDerivative(double d) {
            return d > 0.0 ? 1.0 : 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static class Exponential
    extends Function {
        static double cacheValue = 0.0;
        static double cacheResult = 1.0;

        @Override
        public double map(double d) {
            if (d != cacheValue) {
                cacheValue = d;
                cacheResult = Math.exp(d);
            }
            return cacheResult;
        }

        @Override
        public double mapDerivative(double d) {
            return this.map(d);
        }

        public double mapDoubleDerivative(double d) {
            return this.map(d);
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static class AboutEqual
    extends Function {
        double eqValue = 1.0;
        double range = 0.2;

        public AboutEqual() {
        }

        public AboutEqual(double d, double d2) {
            this.eqValue = d;
            this.range = Math.abs(d2);
        }

        @Override
        public double map(double d) {
            return d < this.eqValue + this.range ? (d > this.eqValue - this.range ? 1.0 : 0.0) : 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            element2.setAttribute("eqValue", String.valueOf(this.eqValue));
            element2.setAttribute("range", String.valueOf(this.range));
            return element2;
        }

        @Override
        public void fromXML(Element element) {
            this.eqValue = Xml.getProperty(element, "eqValue", this.eqValue);
            this.range = Xml.getProperty(element, "range", this.range);
        }
    }

    public static class GreaterThan
    extends Function {
        double minValue = 0.0;

        public GreaterThan() {
        }

        public GreaterThan(double d) {
            this.minValue = d;
        }

        @Override
        public double map(double d) {
            return d > this.minValue ? 1.0 : 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }

        @Override
        public void fromXML(Element element) {
            this.minValue = Xml.getProperty(element, "minValue", this.minValue);
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("minValue", String.valueOf(this.minValue));
        }
    }

    public static class LessThan
    extends Function {
        double maxValue = 0.0;

        public LessThan() {
        }

        public LessThan(double d) {
            this.maxValue = d;
        }

        @Override
        public double map(double d) {
            return d < this.maxValue ? 1.0 : 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }

        @Override
        public void fromXML(Element element) {
            this.maxValue = Xml.getProperty(element, "maxValue", this.maxValue);
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("maxValue", String.valueOf(this.maxValue));
        }
    }

    public static class AtMost
    extends Function {
        double maxValue = 0.0;

        public AtMost() {
        }

        public AtMost(double d) {
            this.maxValue = d;
        }

        @Override
        public double map(double d) {
            return d <= this.maxValue ? 1.0 : 0.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }

        @Override
        public void fromXML(Element element) {
            this.maxValue = Xml.getProperty(element, "maxValue", this.maxValue);
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("maxValue", String.valueOf(this.maxValue));
        }
    }

    public static class AtLeast
    extends Function {
        public double minValue = 1.0;

        public AtLeast() {
        }

        public AtLeast(double d) {
            this.minValue = d;
        }

        @Override
        public double map(double d) {
            return d >= this.minValue ? 1.0 : 0.0;
        }

        @Override
        public double mapDerivative(double d) {
            return 1.0;
        }

        @Override
        public double getMinValue() {
            return 0.0;
        }

        @Override
        public double getMaxValue() {
            return 1.0;
        }

        @Override
        public void fromXML(Element element) {
            this.minValue = Xml.getProperty(element, "minValue", this.minValue);
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            return element2.setAttribute("minValue", String.valueOf(this.minValue));
        }
    }

    public static class Identity
    extends Function {
        @Override
        public double map(double d) {
            return d;
        }

        @Override
        public double mapDerivative(double d) {
            return 1.0;
        }

        @Override
        public double mapSecondDerivative(double d) {
            return 0.0;
        }

        @Override
        public double getMinValue() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public double getMaxValue() {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static class Composition
    extends Function
    implements ComboFunction {
        public Function f = new Identity();
        public Function g = new Identity();

        public Composition() {
        }

        public Composition(Function function, Function function2) {
            this.f = function;
            this.g = function2;
        }

        @Override
        public Composition clone() {
            Composition composition = (Composition)super.clone();
            composition.f = this.f.clone();
            composition.g = this.g.clone();
            return composition;
        }

        @Override
        public double map(double d) {
            return this.g.map(this.f.map(d));
        }

        @Override
        public double mapDerivative(double d) {
            return this.g.mapDerivative(this.f.map(d)) * this.f.mapDerivative(d);
        }

        @Override
        public double mapSecondDerivative(double d) {
            double d2 = this.f.map(d);
            double d3 = this.f.mapDerivative(d);
            return this.g.mapSecondDerivative(d2) * d3 * d3 + this.g.mapDerivative(d2) * this.f.mapSecondDerivative(d);
        }

        @Override
        public double getMinValue() {
            return this.g.getMinValue();
        }

        @Override
        public double getMaxValue() {
            return this.g.getMaxValue();
        }

        @Override
        public void fromXML(Element element) {
            this.f = (Function)Xml.getStorable(element, "f");
            this.g = (Function)Xml.getStorable(element, "g");
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            this.f.toXML(element);
            this.g.toXML(element);
            return element2;
        }
    }

    public static class Scaled
    extends Function
    implements ComboFunction {
        double scaleFactor = 1.0;
        double addFactor = 0.0;
        public Function function = new Identity();

        public Scaled() {
        }

        public Scaled(double d, double d2, Function function) {
            this.scaleFactor = d;
            this.addFactor = d2;
            this.function = function;
        }

        @Override
        public Scaled clone() {
            Scaled scaled = (Scaled)super.clone();
            scaled.function = this.function.clone();
            return scaled;
        }

        @Override
        public double map(double d) {
            return this.function.map(d) * this.scaleFactor + this.addFactor;
        }

        @Override
        public double mapDerivative(double d) {
            return this.function.mapDerivative(d) * this.scaleFactor;
        }

        @Override
        public double mapSecondDerivative(double d) {
            return this.function.mapSecondDerivative(d) * this.scaleFactor;
        }

        @Override
        public double getMinValue() {
            return this.function.getMinValue() * this.scaleFactor + this.addFactor;
        }

        @Override
        public double getMaxValue() {
            return this.function.getMaxValue() * this.scaleFactor + this.addFactor;
        }

        @Override
        public Element toXML(Element element) {
            Element element2 = super.toXML(element);
            element2.setAttribute("scaleFactor", String.valueOf(this.scaleFactor));
            element2.setAttribute("addFactor", String.valueOf(this.addFactor));
            this.function.toXML(element2);
            return element2;
        }

        @Override
        public void fromXML(Element element) {
            this.scaleFactor = Xml.getProperty(element, "scaleFactor", this.scaleFactor);
            this.addFactor = Xml.getProperty(element, "addFactor", this.addFactor);
            this.function = (Function)Xml.getStorable(element, "function");
        }
    }

    static interface ComboFunction {
    }

    public static class NotImplemented
    extends RuntimeException {
        public NotImplemented(String string) {
            super(string);
        }
    }
}

