/*
 * Decompiled with CFR 0.152.
 */
package boone.links;

import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.io.Storable;
import org.jdom2.Element;

public class MultiLink
extends Link
implements Storable {
    private Link baseLink;

    public MultiLink() {
    }

    public MultiLink(Link link) {
        this.baseLink = link;
        this.setID(link.getID());
    }

    public MultiLink(Link link, Neuron neuron, Neuron neuron2, double d) {
        this(link);
        this.setSource(neuron);
        this.setSink(neuron2);
        this.setWeight(d);
    }

    @Override
    public MultiLink clone() {
        MultiLink multiLink = (MultiLink)super.clone();
        multiLink.setID(this.baseLink.getID());
        return multiLink;
    }

    @Override
    public String getName() {
        return this.baseLink.getName();
    }

    @Override
    public double getGradient() {
        return this.baseLink.getGradient();
    }

    @Override
    public void setGradient(double d) {
        this.baseLink.setGradient(d);
    }

    @Override
    public void addGradient(double d) {
        this.baseLink.addGradient(d);
    }

    @Override
    public double getLastGradient() {
        return this.baseLink.getLastGradient();
    }

    @Override
    public void setLastGradient(double d) {
        this.baseLink.setLastGradient(d);
    }

    @Override
    public double getAccu() {
        return this.baseLink.getAccu();
    }

    @Override
    public void setAccu(double d) {
        this.baseLink.setAccu(d);
    }

    public Link getBaseLink() {
        return this.baseLink;
    }

    @Override
    public void reset() {
        super.reset();
        this.baseLink.reset();
    }

    @Override
    public void randomize() {
        this.baseLink.randomize();
    }

    @Override
    public void randomize(double d, double d2) {
        this.baseLink.randomize(d, d2);
    }

    @Override
    public void propagate() {
        this.value = this.source.getOutput() * this.baseLink.getWeight();
        this.sink.addLinkInput(this);
    }

    @Override
    public double getWeight() {
        return this.baseLink.getWeight();
    }

    @Override
    public void setWeight(double d) {
        this.baseLink.setWeight(d);
    }

    @Override
    public void addToWeight(double d) {
        this.baseLink.addToWeight(d);
    }

    @Override
    public Element toXML(Element element) {
        return super.toXML(element);
    }

    @Override
    public void fromXML(Element element, NeuralNet neuralNet) {
        super.fromXML(element, neuralNet);
        Link link = neuralNet.getLinkID(this.getID());
        if (link == null) {
            this.baseLink = new Link(this.weight);
            this.baseLink.setID(this.getID());
        } else {
            this.baseLink = ((MultiLink)link).getBaseLink();
        }
    }
}

