/*
 * Decompiled with CFR 0.152.
 */
package boone.io;

import boone.PatternSet;
import boone.io.BooneIOException;
import boone.io.IOFilter;
import boone.io.Storable;
import boone.util.StreamParser;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SNNSPatternFilter
extends IOFilter {
    @Override
    public void save(Storable storable) throws IOException {
        PatternSet patternSet = (PatternSet)storable;
        PrintWriter printWriter = new PrintWriter(this.file);
        printWriter.print("SNNS pattern definition file V3.2 ");
        printWriter.println("generated at " + new SimpleDateFormat("EEE MMM d H:mm:ss yyyy", Locale.US).format(new Date()));
        printWriter.println("\nNo. of patterns: " + patternSet.size());
        printWriter.println("No. of input units: " + patternSet.getInputPatternSize());
        printWriter.println("No. of output units: " + patternSet.getTargetPatternSize());
        printWriter.println(patternSet.writeValues(' ', true, true));
        printWriter.println("# Generated by Boone SNNSFilter.");
        printWriter.flush();
    }

    @Override
    public Storable load(Storable storable) throws IOException {
        PatternSet patternSet = (PatternSet)storable;
        StreamParser streamParser = new StreamParser(new FileInputStream(this.file));
        this.parse(streamParser, patternSet);
        return patternSet;
    }

    private void parse(StreamParser streamParser, PatternSet patternSet) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (!streamParser.expect("SNNS pattern definition file")) {
            throw new BooneIOException.Parsing("Pattern file header expected");
        }
        streamParser.readSpace();
        streamParser.readWord();
        streamParser.readSpace();
        if (streamParser.expect("generated at")) {
            streamParser.readLine();
        }
        streamParser.readSpace();
        while (Character.isLetter(streamParser.curChar) || streamParser.curChar == '#') {
            String string;
            if (streamParser.readUntilCharOrNewline(':')) {
                streamParser.nextChar();
                streamParser.readSpace();
            }
            streamParser.trimEnd(streamParser.workBuffer);
            switch (string = streamParser.workBuffer.toString()) {
                case "No. of patterns": {
                    n = streamParser.readIntNumber();
                    break;
                }
                case "No. of input units": {
                    n2 = streamParser.readIntNumber();
                    break;
                }
                case "No. of output units": {
                    n3 = streamParser.readIntNumber();
                    break;
                }
            }
            streamParser.readSpaceOnly();
        }
        if (n == 0 || n2 == 0 || n3 == 0) {
            throw new BooneIOException.Parsing("Invalid or incomplete file header");
        }
        for (int i = 0; i < n; ++i) {
            patternSet.getInputs().add(this.readValues(streamParser, n2, ' ', null));
            patternSet.getTargets().add(this.readValues(streamParser, n3, ' ', null));
        }
    }
}

