/*
 * Decompiled with CFR 0.152.
 */
package boone.io;

import boone.Link;
import boone.NeuralNet;
import boone.Neuron;
import boone.Trainer;
import boone.io.IOFilter;
import boone.io.Storable;
import boone.map.Function;
import boone.map.Position;
import boone.training.BackpropTrainer;
import boone.training.RpropTrainer;
import boone.util.Common;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

public class SNNSNetFilter
extends IOFilter {
    protected static final String snnsFileHeader = "SNNS network definition file";
    public float xOrigin = 10.0f;
    public float yOrigin = 40.0f;
    public float gridWidth = 41.0f;

    @Override
    public Storable load(Storable storable) throws IOException {
        if (!this.isMatching(this.file)) {
            throw new IOException(this.file + " has incorrect SNNS header!");
        }
        int n = (int)this.file.length();
        char[] cArray = new char[n];
        InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(this.file));
        n = inputStreamReader.read(cArray, 0, n);
        inputStreamReader.close();
        ENSNNSParser eNSNNSParser = new ENSNNSParser(cArray, 0, n);
        NeuralNet neuralNet = new NeuralNet();
        eNSNNSParser.netFile(neuralNet);
        for (int i = 0; i < neuralNet.getNeuronCount(); ++i) {
            Neuron neuron = neuralNet.getNeuron(i);
            Position position = neuron.getPosition();
            position.setXPos(position.getXPos() * this.gridWidth + this.xOrigin);
            position.setYPos(position.getYPos() * this.gridWidth + this.yOrigin);
            position.setZPos(position.getZPos() * this.gridWidth);
        }
        return neuralNet;
    }

    @Override
    public void save(Storable storable) throws IOException {
        int n;
        Cloneable cloneable;
        Neuron neuron;
        int n2;
        NeuralNet neuralNet = (NeuralNet)storable;
        StringBuffer stringBuffer = new StringBuffer("SNNS network definition file V1.4-3D");
        String string = this.getSNNSLearnFunction(neuralNet);
        String string2 = "Topological_Order";
        int n3 = neuralNet.getNeuronCount();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM d H:mm:ss yyyy", Locale.US);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("0.00000", decimalFormatSymbols);
        stringBuffer.append("\ngenerated at ").append(simpleDateFormat.format(new Date()));
        stringBuffer.append("\n\nnetwork name : ").append(this.file.getName());
        stringBuffer.append("\nsource files :\nno. of units : ").append(n3);
        stringBuffer.append("\nno. of connections : ").append(neuralNet.getLinkCount());
        stringBuffer.append("\nno. of unit types : 0\nno. of site types : 0");
        stringBuffer.append("\n\nlearning function : ").append(string);
        stringBuffer.append("\nupdate function   : ").append(string2);
        stringBuffer.append("\n\nunit default section :");
        stringBuffer.append("\n\nact      | bias     | st | subnet | layer | act func     | out func");
        stringBuffer.append("\n---------|----------|----|--------|-------|--------------|-------------");
        stringBuffer.append("\n 0.00000 |  0.00000 | h  |      0 |     1 | Act_Logistic | Out_Identity ");
        stringBuffer.append("\n---------|----------|----|--------|-------|--------------|-------------");
        stringBuffer.append("\n\nunit definition section :");
        stringBuffer.append("\n\nno. | typeName | unitName | act      | bias     | st | position | act func | out func | sites");
        stringBuffer.append("\n----|----------|----------|----------|----------|----|----------|----------|----------|-------");
        for (n2 = 0; n2 < n3; ++n2) {
            neuron = neuralNet.getNeuron(n2);
            cloneable = neuron.getPosition();
            int n4 = Math.round((((Position)cloneable).getXPos() - this.xOrigin) / this.gridWidth);
            n = Math.round((((Position)cloneable).getYPos() - this.yOrigin) / this.gridWidth);
            int n5 = Math.round(((Position)cloneable).getZPos() / this.gridWidth);
            stringBuffer.append("\n").append(n2 + 1).append("   |          | ").append(Common.stripOff(neuron.getName(), ' ')).append("\t| ").append(decimalFormat.format(neuron.getOutput())).append("  | ").append(decimalFormat.format(neuron.getBias())).append("\t| ").append(this.getTypeString(neuron)).append(" |  ").append(Integer.toString(n4)).append(",").append(Integer.toString(n)).append(",").append(Integer.toString(n5)).append(" | ").append(this.getSNNSActFunctionName(neuron.getActivationFn(), neuralNet)).append(" | Out_Identity |");
        }
        stringBuffer.append("\n----|----------|----------|----------|----------|----|----------|----------|----------|-------");
        stringBuffer.append("\n\nconnection definition section :");
        stringBuffer.append("\n\ntarget | site | source:weight");
        stringBuffer.append("\n-------|------|---------------------------------------------------------------------------------------------------------------------");
        for (n2 = 0; n2 < n3; ++n2) {
            neuron = neuralNet.getNeuron(n2);
            if (neuron.isInputNeuron() && !neuron.isOutputNeuron() || ((ArrayList)(cloneable = neuron.getLinks())).size() <= 0) continue;
            StringBuffer stringBuffer2 = new StringBuffer("\n   ");
            stringBuffer2.append(n2 + 1).append(" |      |  ");
            n = 0;
            Iterator iterator = ((ArrayList)cloneable).iterator();
            while (iterator.hasNext()) {
                Link link = (Link)iterator.next();
                if (!link.isInputOf(neuron)) continue;
                if (n++ > 0) {
                    stringBuffer2.append(", ");
                    if (n % 10 == 0) {
                        stringBuffer2.append("\n                ");
                    }
                }
                stringBuffer2.append(neuralNet.getNeuronIndex(link.getSource()) + 1).append(": ").append(decimalFormat.format(link.getWeight()));
            }
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer.append("\n-------|------|---------------------------------------------------------------------------------------------------------------------");
        PrintWriter printWriter = new PrintWriter(this.file);
        printWriter.println(stringBuffer.toString());
        printWriter.flush();
    }

    private String getTypeString(Neuron neuron) {
        if (neuron.isInputNeuron()) {
            return "i ";
        }
        if (neuron.isOutputNeuron()) {
            return "o ";
        }
        return "h ";
    }

    private String getSNNSLearnFunction(NeuralNet neuralNet) {
        Trainer trainer = neuralNet.getTrainer();
        if (trainer instanceof BackpropTrainer) {
            return "Std_Backpropagation";
        }
        if (trainer instanceof RpropTrainer) {
            return "Rprop";
        }
        neuralNet.props.setProperty("Learning Function", "unknown (set to default)");
        return "Std_Backpropagation";
    }

    private String getSNNSActFunctionName(Function function, NeuralNet neuralNet) {
        if (function == null || function instanceof Function.Identity) {
            return "Act_Identity";
        }
        if (function instanceof Function.AtLeast) {
            Function.AtLeast atLeast = (Function.AtLeast)function;
            if (atLeast.minValue == 2.0) {
                return "Act_at_least_2";
            }
            if (atLeast.minValue != 1.0) {
                neuralNet.props.setProperty("Activation Function", "Unknown (set to Act_at_least_1)");
                return "Act_at_least_1";
            }
        }
        if (function instanceof Function.AtMost) {
            return "Act_at_most_0";
        }
        if (function instanceof Function.AboutEqual) {
            return "Act_exactly_1";
        }
        if (function instanceof Function.CatmullRomSpline) {
            return "Act_CatmullRomSpline";
        }
        if (function instanceof Function.Exponential) {
            return "Act_Exponential";
        }
        if (function instanceof Function.LessThan) {
            return "Act_less_than_0";
        }
        if (function instanceof Function.NaturalSpline) {
            return "Act_NaturalSpline";
        }
        if (function instanceof Function.Sigmoid) {
            return "Act_Logistic";
        }
        if (function instanceof Function.SignumWithoutZero) {
            return "Act_Signum";
        }
        if (function instanceof Function.Signum) {
            return "Act_Signum0";
        }
        if (function instanceof Function.Sinus) {
            return "Act_Sinus";
        }
        if (function instanceof Function.GreaterThan) {
            return "Act_StepFunc";
        }
        if (function instanceof Function.TanH) {
            return "Act_TanH";
        }
        neuralNet.props.setProperty("Activation Function", "Unknown (set to Act_Identity)");
        return "Act_Identity";
    }

    private boolean isMatching(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            return string.startsWith(snnsFileHeader);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static class ENSNNSParser
    extends ENSNNSLexicalAnalyzer {
        private String _name = null;
        protected int _numUnits = 0;
        protected int _numConnections = 0;
        protected int _numUnitTypes = 0;
        protected int _numSiteTypes = 0;
        private String _learningFunc = null;
        protected String _pruningFunc = null;
        protected String _ffLearningFunc = null;
        protected String _updateFunc = null;
        private double _defaultActivation = 0.0;
        private double _defaultBias = 0.0;
        private String _defaultST = "h";
        protected int _defaultSubnet = 0;
        protected int _defaultLayer = 1;
        private String _defaultActFunc = "Act_Logistic";
        protected String _defaultOutFunc = "Out_Identity";
        private String[] _siteNames = null;
        private String[] _siteFuncs = null;
        private String[] _typeNames = null;
        private String[] _typeActFuncs = null;
        private String[] _typeOutFuncs = null;
        private String[] _typeSites = null;
        private int _in;
        private int _hidden;
        private int _out;

        public ENSNNSParser(char[] cArray, int n, int n2) {
            super(cArray, n, n2);
        }

        public void netFile(NeuralNet neuralNet) throws IOException {
            this.fileHeader();
            this.sections(neuralNet);
            Trainer trainer = this.createTrainer(this._learningFunc);
            neuralNet.setTrainer(trainer);
        }

        private Trainer createTrainer(String string) throws IOException {
            if ("Std_Backpropagation".equals(string) || "BackpropMomentum".equals(string)) {
                return new BackpropTrainer();
            }
            if ("Rprop".equals(string)) {
                return new RpropTrainer();
            }
            return new BackpropTrainer();
        }

        public void fileHeader() throws IOException {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            block14: while (!bl4) {
                int n = this.getNextToken(true);
                switch (n) {
                    case 259: {
                        this.getNextToken();
                        if (this.getNextToken() != 258) {
                            throw new IOException("Expected SNNS network file version number in line: " + this._lineNo);
                        }
                        bl = true;
                        continue block14;
                    }
                    case 260: {
                        this.getNextToken();
                        this.skipToNextLine();
                        continue block14;
                    }
                    case 261: {
                        this.getNextToken();
                        this._name = this.parseHeaderString();
                        continue block14;
                    }
                    case 262: {
                        this.getNextToken();
                        this.skipToNextLine();
                        continue block14;
                    }
                    case 263: {
                        this.getNextToken();
                        this._numUnits = this.parseHeaderInteger(1, Integer.MAX_VALUE);
                        bl2 = true;
                        continue block14;
                    }
                    case 264: {
                        this.getNextToken();
                        this._numConnections = this.parseHeaderInteger(0, Integer.MAX_VALUE);
                        bl3 = true;
                        continue block14;
                    }
                    case 265: {
                        this.getNextToken();
                        this._numUnitTypes = this.parseHeaderInteger(0, Integer.MAX_VALUE);
                        continue block14;
                    }
                    case 266: {
                        this.getNextToken();
                        this._numSiteTypes = this.parseHeaderInteger(0, Integer.MAX_VALUE);
                        continue block14;
                    }
                    case 267: {
                        this.getNextToken();
                        this._learningFunc = this.parseHeaderString();
                        continue block14;
                    }
                    case 268: {
                        this.getNextToken();
                        this._pruningFunc = this.parseHeaderString();
                        continue block14;
                    }
                    case 269: {
                        this.getNextToken();
                        this._ffLearningFunc = this.parseHeaderString();
                        continue block14;
                    }
                    case 270: {
                        this.getNextToken();
                        this._updateFunc = this.parseHeaderString();
                        continue block14;
                    }
                }
                bl4 = true;
            }
            if (!bl) {
                throw new IOException("This is not a valid SNNS network file");
            }
            if (!bl2) {
                throw new IOException("Mandatory number of units is missing");
            }
            if (!bl3) {
                throw new IOException("Mandatory number of connections is missing");
            }
        }

        private int parseHeaderInteger(int n, int n2) throws IOException {
            if (this.getNextToken() != 58) {
                throw new IOException("Missing ':' in line: " + this._lineNo);
            }
            int n3 = this.getNextToken();
            if (n3 != 257 && n3 != 256) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            if ((double)((int)this._doubleValue) - this._doubleValue != 0.0) {
                throw new IOException("Expected integer in line: " + this._lineNo);
            }
            int n4 = (int)this._doubleValue;
            if (n4 < n || n4 > n2) {
                throw new IOException("The integer " + n4 + " is out of range. Line: " + this._lineNo);
            }
            return n4;
        }

        private String parseHeaderString() throws IOException {
            if (this.getNextToken() != 58) {
                throw new IOException("Missing ':' in line: " + this._lineNo);
            }
            this.setImplicitQuoting(true);
            if (this.getNextToken() != 307) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            this.setImplicitQuoting(false);
            return this._stringValue.trim();
        }

        public void sections(NeuralNet neuralNet) throws IOException {
            int n = -1;
            boolean bl = false;
            boolean bl2 = false;
            block11: while (!bl2) {
                n = this.getNextToken(true);
                switch (n) {
                    case 271: {
                        this.getNextToken();
                        this.unitSection(neuralNet);
                        bl = true;
                        continue block11;
                    }
                    case 272: {
                        this.getNextToken();
                        this.defaultSection();
                        continue block11;
                    }
                    case 273: {
                        this.getNextToken();
                        this.siteSection();
                        continue block11;
                    }
                    case 274: {
                        this.getNextToken();
                        this.typeSection();
                        continue block11;
                    }
                    case 275: {
                        this.getNextToken();
                        this.connectionSection(neuralNet);
                        continue block11;
                    }
                    case 276: {
                        this.getNextToken();
                        this.layerSection();
                        continue block11;
                    }
                    case 277: {
                        this.getNextToken();
                        this.subnetSection();
                        continue block11;
                    }
                    case 278: {
                        this.getNextToken();
                        this.translationSection();
                        continue block11;
                    }
                    case 279: {
                        this.getNextToken();
                        this.timeDelaySection();
                        continue block11;
                    }
                }
                bl2 = true;
            }
            if (!bl) {
                throw new IOException("Mandatory unit section is missing");
            }
            if (n != -1) {
                throw new IOException("Excess data in line: " + this._lineNo);
            }
        }

        private void defaultSection() throws IOException {
            this.parseToken(283, true);
            this.parseToken(284, true);
            this.parseToken(285, true);
            this.parseToken(287, true);
            this.parseToken(288, true);
            this.parseTwinToken(283, 289, true);
            this.parseTwinToken(290, 289, false);
            this.parseColumnLine(7);
            this.setSuppressKeywords(true);
            this._defaultActivation = this.parseSectionFloat();
            this.parseColumnSep();
            this._defaultBias = this.parseSectionFloat();
            this.parseColumnSep();
            this._defaultST = this.parseSectionString();
            this.parseColumnSep();
            this._defaultSubnet = this.parseSectionInteger(0, 1000);
            this.parseColumnSep();
            this._defaultLayer = this.parseSectionInteger(0, 255);
            this.parseColumnSep();
            this._defaultActFunc = this.parseSectionString();
            this.parseColumnSep();
            this._defaultOutFunc = this.parseSectionString();
            this.setSuppressKeywords(false);
            this.parseColumnLine(7);
        }

        private void siteSection() throws IOException {
            boolean bl = false;
            int n = 0;
            this.parseToken(292, true);
            this.parseToken(293, false);
            this.parseColumnLine(2);
            this.setSuppressKeywords(true);
            while (!bl) {
                String string = this.parseSectionString();
                this.parseColumnSep();
                String string2 = this.parseSectionString();
                String[] stringArray = new String[n + 1];
                String[] stringArray2 = new String[n + 1];
                if (n > 0) {
                    System.arraycopy(this._siteNames, 0, stringArray, 0, n);
                    System.arraycopy(this._siteFuncs, 0, stringArray2, 0, n);
                }
                stringArray[n] = string;
                stringArray2[n] = string2;
                this._siteNames = stringArray;
                this._siteFuncs = stringArray2;
                ++n;
                if (this.getNextToken(true) != 308) continue;
                bl = true;
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(2);
        }

        private void typeSection() throws IOException {
            boolean bl = false;
            int n = 0;
            this.parseToken(294, true);
            this.parseTwinToken(283, 289, true);
            this.parseTwinToken(290, 289, true);
            this.parseToken(291, false);
            this.parseColumnLine(4);
            this.setPassNewlines(true);
            this.getNextToken();
            this.setSuppressKeywords(true);
            while (!bl) {
                String string = this.parseSectionString();
                this.parseColumnSep();
                String string2 = this.parseSectionString();
                this.parseColumnSep();
                String string3 = this.parseSectionString();
                this.parseColumnSep();
                String string4 = "";
                if (this.getNextToken(true) == 307) {
                    string4 = this.parseSectionString();
                }
                if (this.getNextToken() != 10) {
                    throw new IOException("Syntax error in line: " + this._lineNo);
                }
                String[] stringArray = new String[n + 1];
                String[] stringArray2 = new String[n + 1];
                String[] stringArray3 = new String[n + 1];
                String[] stringArray4 = new String[n + 1];
                if (n > 0) {
                    System.arraycopy(this._typeNames, 0, stringArray, 0, n);
                    System.arraycopy(this._typeActFuncs, 0, stringArray2, 0, n);
                    System.arraycopy(this._typeOutFuncs, 0, stringArray3, 0, n);
                    System.arraycopy(this._typeSites, 0, stringArray4, 0, n);
                }
                stringArray[n] = string;
                stringArray2[n] = string2;
                stringArray3[n] = string3;
                stringArray4[n] = string4;
                this._typeNames = stringArray;
                this._typeActFuncs = stringArray2;
                this._typeOutFuncs = stringArray3;
                this._typeSites = stringArray4;
                ++n;
                if (this.getNextToken(true) != 308) continue;
                bl = true;
            }
            this.setSuppressKeywords(false);
            this.setPassNewlines(false);
            this.parseColumnLine(4);
        }

        private void subnetSection() throws IOException {
            this.parseToken(287, true);
            this.parseToken(298, false);
            this.parseColumnLine(2);
            this.setSuppressKeywords(true);
            while (this.getNextToken(true) != 308) {
                this.getNextToken();
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(2);
        }

        private void unitSection(NeuralNet neuralNet) throws IOException {
            boolean bl = false;
            this._out = 0;
            this._hidden = 0;
            this._in = 0;
            this.parseToken(280, true);
            this.parseToken(281, true);
            this.parseToken(282, true);
            this.parseToken(283, true);
            this.parseToken(284, true);
            this.parseToken(285, true);
            this.parseToken(286, true);
            this.parseTwinToken(283, 289, true);
            this.parseTwinToken(290, 289, true);
            this.parseToken(291, false);
            this.parseColumnLine(10);
            this.setSuppressKeywords(true);
            while (!bl) {
                boolean bl2;
                this.parseSectionInteger(0, Integer.MAX_VALUE);
                this.parseColumnSep();
                if (this.getNextToken(true) == 307) {
                    this.parseSectionString();
                }
                this.parseColumnSep();
                String string = this.getNextToken(true) == 307 ? this.parseSectionString() : null;
                this.parseColumnSep();
                int n = this.getNextToken(true);
                double d = n == 257 || n == 256 ? this.parseSectionFloat() : this._defaultActivation;
                this.parseColumnSep();
                n = this.getNextToken(true);
                double d2 = n == 257 || n == 256 ? this.parseSectionFloat() : this._defaultBias;
                this.parseColumnSep();
                String string2 = this.getNextToken(true) == 307 ? this.parseSectionString() : this._defaultST;
                this.parseColumnSep();
                float f = (float)this.parseSectionFloat();
                if (this.getNextToken() != 44) {
                    throw new IOException("Syntax error in line: " + this._lineNo);
                }
                float f2 = (float)this.parseSectionFloat();
                if (this.getNextToken() != 44) {
                    throw new IOException("Syntax error in line: " + this._lineNo);
                }
                float f3 = (float)this.parseSectionFloat();
                this.parseColumnSep();
                String string3 = this.getNextToken(true) == 307 ? this.parseSectionString() : this._defaultActFunc;
                this.parseColumnSep();
                if (this.getNextToken(true) == 307) {
                    this.parseSectionString();
                }
                this.parseColumnSep();
                if (this.getNextToken(true) == 307) {
                    this.parseSectionString();
                }
                boolean bl3 = "i".equals(string2) || "si".equals(string2);
                boolean bl4 = bl2 = "o".equals(string2) || "so".equals(string2);
                if (bl3) {
                    ++this._in;
                } else if (bl2) {
                    ++this._out;
                } else {
                    ++this._hidden;
                }
                Function function = bl3 ? null : this.createActFunction(string3);
                Neuron neuron = new Neuron(bl3, bl2, !bl3);
                neuralNet.addNeuron(neuron);
                if (string != null) {
                    neuron.setName(string);
                } else if (bl3) {
                    neuron.setName("Input " + neuralNet.getInputNeuronCount());
                } else if (bl2) {
                    neuron.setName("Output " + neuralNet.getOutputNeuronCount());
                } else {
                    neuron.setName("Hidden " + neuralNet.getHiddenNeuronCount());
                }
                neuron.setActivationFn(function);
                neuron.setExternalInput(d);
                neuron.setBias(d2);
                neuron.getPosition().set(f, f2, f3);
                if (this.getNextToken(true) != 308) continue;
                bl = true;
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(10);
        }

        private void connectionSection(NeuralNet neuralNet) throws IOException {
            boolean bl = false;
            int n = 308;
            Trainer trainer = neuralNet.getTrainer();
            this.parseToken(295, true);
            this.parseToken(296, true);
            this.parseToken(297, false);
            this.parseColumnLine(3);
            this.setSuppressKeywords(true);
            while (!bl) {
                int n2 = this.parseSectionInteger(0, Integer.MAX_VALUE);
                this.parseColumnSep();
                if (this.getNextToken(true) == 307) {
                    this.parseSectionString();
                }
                this.parseColumnSep();
                boolean bl2 = false;
                while (!bl2) {
                    int n3 = this.parseSectionInteger(0, Integer.MAX_VALUE);
                    if (this.getNextToken() != 58) {
                        throw new IOException("Syntax error in line: " + this._lineNo);
                    }
                    double d = this.parseSectionFloat();
                    Neuron neuron = neuralNet.getNeuron(n3 - 1);
                    Neuron neuron2 = neuralNet.getNeuron(n2 - 1);
                    Link link = new Link(neuron, neuron2, d);
                    neuralNet.addLink(link);
                    link.setName("Link from " + neuron.getName() + " to " + neuron2.getName());
                    n = this.getNextToken(true);
                    if (n != 44) {
                        bl2 = true;
                        continue;
                    }
                    this.getNextToken();
                }
                if (n != 308) continue;
                bl = true;
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(3);
        }

        private void layerSection() throws IOException {
            this.parseToken(288, true);
            this.parseToken(298, false);
            this.parseColumnLine(2);
            this.setSuppressKeywords(true);
            while (this.getNextToken(true) != 308) {
                this.getNextToken();
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(2);
        }

        private void translationSection() throws IOException {
            this.parseToken(299, true);
            this.parseToken(300, true);
            this.parseToken(301, false);
            this.parseColumnLine(3);
            this.setSuppressKeywords(true);
            while (this.getNextToken(true) != 308) {
                this.getNextToken();
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(3);
        }

        private void timeDelaySection() throws IOException {
            this.parseToken(280, true);
            this.parseToken(302, true);
            this.parseToken(303, true);
            this.parseToken(304, true);
            this.parseToken(305, true);
            this.parseToken(306, false);
            this.parseColumnLine(6);
            this.setSuppressKeywords(true);
            while (this.getNextToken(true) != 308) {
                this.getNextToken();
            }
            this.setSuppressKeywords(false);
            this.parseColumnLine(6);
        }

        private void parseToken(int n, boolean bl) throws IOException {
            if (this.getNextToken() != n) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            if (bl && this.getNextToken() != 124) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
        }

        private void parseTwinToken(int n, int n2, boolean bl) throws IOException {
            if (this.getNextToken() != n) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            if (this.getNextToken() != n2) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            if (bl && this.getNextToken() != 124) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
        }

        private void parseColumnLine(int n) throws IOException {
            if (this.getNextToken() != 308) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            for (int i = 0; i < n - 1; ++i) {
                if (this.getNextToken() != 124) {
                    throw new IOException("Syntax error in line: " + this._lineNo);
                }
                if (this.getNextToken() == 308) continue;
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
        }

        private void parseColumnSep() throws IOException {
            if (this.getNextToken() != 124) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
        }

        private double parseSectionFloat() throws IOException {
            return this.parseSectionFloat(-1.7976931348623157E308, Double.MAX_VALUE);
        }

        private double parseSectionFloat(double d, double d2) throws IOException {
            int n = this.getNextToken();
            if (n != 257 && n != 256) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            if (this._doubleValue < d || this._doubleValue > d2) {
                throw new IOException("The float " + this._doubleValue + " is out of range. Line: " + this._lineNo);
            }
            return this._doubleValue;
        }

        private int parseSectionInteger(int n, int n2) throws IOException {
            int n3 = this.getNextToken();
            if (n3 != 257 && n3 != 256) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            if ((double)((int)this._doubleValue) - this._doubleValue != 0.0) {
                throw new IOException("Expected integer in line: " + this._lineNo);
            }
            int n4 = (int)this._doubleValue;
            if (n4 < n || n4 > n2) {
                throw new IOException("The integer " + n4 + " is out of range. Line: " + this._lineNo);
            }
            return n4;
        }

        private String parseSectionString() throws IOException {
            if (this.getNextToken() != 307) {
                throw new IOException("Syntax error in line: " + this._lineNo);
            }
            return this._stringValue;
        }

        private Function createActFunction(String string) {
            if ("Act_Identity".equals(string)) {
                return null;
            }
            if ("Act_IdentityPlusBias".equals(string)) {
                return null;
            }
            if ("Act_at_least_1".equals(string)) {
                return new Function.AtLeast(1.0);
            }
            if ("Act_at_least_2".equals(string)) {
                return new Function.AtLeast(2.0);
            }
            if ("Act_at_most_0".equals(string)) {
                return new Function.AtMost(0.0);
            }
            if ("Act_CatmullRomSpline".equals(string)) {
                return new Function.CatmullRomSpline();
            }
            if ("Act_exactly_1".equals(string)) {
                return new Function.AboutEqual(1.0, 0.2);
            }
            if ("Act_Exponential".equals(string)) {
                return new Function.Exponential();
            }
            if ("Act_less_than_0".equals(string)) {
                return new Function.LessThan(0.0);
            }
            if ("Act_NaturalSpline".equals(string)) {
                return new Function.NaturalSpline();
            }
            if ("Act_Logistic".equals(string)) {
                return new Function.Sigmoid();
            }
            if ("Act_Signum".equals(string)) {
                return new Function.SignumWithoutZero();
            }
            if ("Act_Signum0".equals(string)) {
                return new Function.Signum();
            }
            if ("Act_Sinus".equals(string)) {
                return new Function.Sinus();
            }
            if ("Act_StepFunc".equals(string)) {
                return new Function.GreaterThan(0.0);
            }
            if ("Act_TanH".equals(string)) {
                return new Function.TanH();
            }
            return new Function.Sigmoid();
        }
    }

    public static class ENSNNSLexicalAnalyzer {
        public static final int EOF = -1;
        public static final int INTEGER = 256;
        public static final int NUMBER = 257;
        public static final int STRING = 307;
        public static final int DASHES = 308;
        public static final int VERSION = 258;
        public static final int SNNS = 259;
        public static final int GENERATED_AT = 260;
        public static final int NETWORK_NAME = 261;
        public static final int SOURCE_FILES = 262;
        public static final int NO_OF_UNITS = 263;
        public static final int NO_OF_CONNECTIONS = 264;
        public static final int NO_OF_UNIT_TYPES = 265;
        public static final int NO_OF_SITE_TYPES = 266;
        public static final int LEARNING_FUNCTION = 267;
        public static final int PRUNING_FUNCTION = 268;
        public static final int FF_LEARNING_FUNCTION = 269;
        public static final int UPDATE_FUNCTION = 270;
        public static final int UNIT_SECTION_TITLE = 271;
        public static final int DEFAULT_SECTION_TITLE = 272;
        public static final int SITE_SECTION_TITLE = 273;
        public static final int TYPE_SECTION_TITLE = 274;
        public static final int CONNECTION_SECTION_TITLE = 275;
        public static final int LAYER_SECTION_TITLE = 276;
        public static final int SUBNET_SECTION_TITLE = 277;
        public static final int TRANSLATION_SECTION_TITLE = 278;
        public static final int TIME_DELAY_SECTION_TITLE = 279;
        public static final int NO = 280;
        public static final int TYPE_NAME = 281;
        public static final int UNIT_NAME = 282;
        public static final int ACT = 283;
        public static final int BIAS = 284;
        public static final int ST = 285;
        public static final int POSITION = 286;
        public static final int SUBNET = 287;
        public static final int LAYER = 288;
        public static final int FUNC = 289;
        public static final int OUT = 290;
        public static final int SITES = 291;
        public static final int SITE_NAME = 292;
        public static final int SITE_FUNCTION = 293;
        public static final int NAME = 294;
        public static final int TARGET = 295;
        public static final int SITE = 296;
        public static final int SOURCE_WEIGHT = 297;
        public static final int UNIT_NO = 298;
        public static final int DELTA_X = 299;
        public static final int DELTA_Y = 300;
        public static final int Z = 301;
        public static final int LLN = 302;
        public static final int LUN = 303;
        public static final int TOFF = 304;
        public static final int SOFF = 305;
        public static final int CTYPE = 306;
        private static final int UNKNOWN = Integer.MAX_VALUE;
        protected double _doubleValue = 0.0;
        protected int _intValue = 0;
        protected String _stringValue = "";
        protected int _lineNo;
        private boolean _implicitQuoting = false;
        private boolean _passNewlines = false;
        private boolean _suppressKeywords = false;
        private int _pos = 0;
        private int _length = 0;
        private char[] _source = null;
        private String[] _keywords = new String[]{"typeName", "unitName", "act", "bias", "func", "st", "position", "subnet", "out", "sites", "site name", "site function", "name", "target", "source:weight", "unitNo.", "delta x", "delta y", "z", "LLN", "LUN", "Toff", "Soff", "Ctype", "SNNS network definition file", "generated at", "network name", "source files", "no. of units", "no. of connections", "no. of unit types", "no. of site types", "no.", "learning function", "pruning function", "subordinate learning function", "update function", "unit definition section :", "unit default section :", "site definition section :", "type definition section :", "connection definition section :", "layer definition section :", "subnet definition section :", "time delay section :", "layer", "site", "V1.4-3D", "V2.1", "V3.0"};
        private int[] _tokens = new int[]{281, 282, 283, 284, 289, 285, 286, 287, 290, 291, 292, 293, 294, 295, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 259, 260, 261, 262, 263, 264, 265, 266, 280, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 279, 288, 296, 258, 258, 258};

        public ENSNNSLexicalAnalyzer(char[] cArray, int n, int n2) {
            if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
                throw new IllegalArgumentException();
            }
            this._source = cArray;
            this._pos = n;
            this._length = n2;
            this._lineNo = 1;
        }

        protected int getNextToken(boolean bl) throws IOException {
            int n = this._pos;
            int n2 = Integer.MAX_VALUE;
            block13: while (n2 == Integer.MAX_VALUE && this._pos < this._length) {
                int n3 = this._source[this._pos++];
                block0 : switch (n3) {
                    case 9: 
                    case 13: 
                    case 32: {
                        break;
                    }
                    case 10: {
                        if (!bl) {
                            ++this._lineNo;
                        }
                        if (!this._passNewlines) continue block13;
                        n2 = 10;
                        break;
                    }
                    case 35: {
                        while (this._pos < this._length) {
                            if (this._source[this._pos] == '\n') break block0;
                            ++this._pos;
                        }
                        continue block13;
                    }
                    case 45: {
                        if (!this._implicitQuoting && this._pos < this._length && this._source[this._pos] == '-') {
                            this.parseDashes();
                            n2 = 308;
                            break;
                        }
                    }
                    case 43: {
                        if (!this._implicitQuoting) {
                            --this._pos;
                            this._doubleValue = this.parseNumber();
                            n2 = 257;
                            break;
                        }
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: {
                        if (!this._implicitQuoting && this._source[this._pos] == 'D' && this.regionMatches(this._pos - 1, "3D translation section :", 24)) {
                            this._pos += 23;
                            n2 = 278;
                            break;
                        }
                    }
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        if (!this._implicitQuoting) {
                            --this._pos;
                            if (this.isProbableNumber()) {
                                this._doubleValue = this.parseNumber();
                                this._intValue = (int)this._doubleValue;
                                n2 = 257;
                                break;
                            }
                            this._intValue = this.parseInteger();
                            this._doubleValue = this._intValue;
                            n2 = 256;
                            break;
                        }
                    }
                    default: {
                        if (this._implicitQuoting || Character.isLetter((char)n3)) {
                            int n4;
                            int n5;
                            n2 = Integer.MAX_VALUE;
                            if (!this._suppressKeywords && !this._implicitQuoting) {
                                n5 = this.textLength();
                                for (int i = 0; i < this._keywords.length; ++i) {
                                    n4 = Math.max(n5, this._keywords[i].length());
                                    if (!this.regionMatches(this._pos - 1, this._keywords[i], n4)) continue;
                                    this._pos += this._keywords[i].length() - 1;
                                    n2 = this._tokens[i];
                                    break;
                                }
                            }
                            if (n2 != Integer.MAX_VALUE) continue block13;
                            n4 = this._pos - 1;
                            n5 = 0;
                            while (n5 == 0 && this._pos < this._length) {
                                switch (this._source[this._pos++]) {
                                    case '\t': 
                                    case '\r': 
                                    case ' ': {
                                        if (this._implicitQuoting) break;
                                        n5 = 1;
                                        break;
                                    }
                                    case '\n': {
                                        if (!bl) {
                                            ++this._lineNo;
                                        }
                                        n5 = 1;
                                    }
                                }
                            }
                            this._stringValue = new String(this._source, n4, this._pos - n4 - 1);
                            n2 = 307;
                            break;
                        }
                        n2 = n3;
                    }
                }
            }
            if (bl) {
                this._pos = n;
            }
            return n2 != Integer.MAX_VALUE ? n2 : -1;
        }

        public int getNextToken() throws IOException {
            return this.getNextToken(false);
        }

        public void setImplicitQuoting(boolean bl) {
            this._implicitQuoting = bl;
        }

        public boolean isImplicitQuoting() {
            return this._implicitQuoting;
        }

        public void setPassNewlines(boolean bl) {
            this._passNewlines = bl;
        }

        public boolean isPassNewlines() {
            return this._passNewlines;
        }

        public void setSuppressKeywords(boolean bl) {
            this._suppressKeywords = bl;
        }

        public boolean isSuppressKeywords() {
            return this._suppressKeywords;
        }

        private int textLength() {
            int n = 0;
            int n2 = this._pos - 1;
            while (n2 < this._length && !Character.isWhitespace(this._source[n2++])) {
                ++n;
            }
            return n;
        }

        private boolean regionMatches(int n, String string, int n2) {
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) == this._source[n++]) continue;
                return false;
            }
            return true;
        }

        protected void skipToNextLine() {
            while (this._pos < this._length) {
                if (this._source[this._pos++] != '\n') continue;
                ++this._lineNo;
                return;
            }
        }

        private void parseDashes() {
            while (this._pos < this._length && this._source[this._pos++] == '-') {
            }
            --this._pos;
        }

        private boolean isProbableNumber() {
            int n = this._pos;
            while (n < this._length) {
                char c;
                if ((c = this._source[n++]) == '.' || c == 'e' || c == 'E') {
                    return true;
                }
                if (c >= '0' && c <= '9') continue;
                return false;
            }
            return false;
        }

        private int parseInteger() throws IOException {
            long l = 0L;
            long l2 = Integer.MAX_VALUE;
            boolean bl = false;
            if (this._source[this._pos] == '-') {
                ++this._pos;
                bl = true;
            } else if (this._source[this._pos] == '+') {
                ++this._pos;
            }
            while (this._pos < this._length) {
                char c = this._source[this._pos];
                if (c < '0' || c > '9') {
                    return (int)(!bl ? l : -l);
                }
                if (l > l2) {
                    throw new IOException("The integer (" + l + ") in line " + this._lineNo + " is too large.");
                }
                l *= 10L;
                l += (long)(c - 48);
                ++this._pos;
            }
            throw new IOException("Unexpected end of file in line: " + this._lineNo);
        }

        private double parseNumber() throws IOException {
            char c;
            int n = this._pos;
            String string = "";
            while (n < this._length && (c = this._source[n++]) != ' ' && c != '\t' && c != '\n' && c != ',') {
            }
            --n;
            try {
                string = new String(this._source, this._pos, n - this._pos);
                double d = Double.parseDouble(string);
                this._pos = n;
                return d;
            }
            catch (Exception exception) {
                throw new IOException("Malformed number \"" + string + "\" in line: " + this._lineNo);
            }
        }
    }
}

