/*
 * Decompiled with CFR 0.152.
 */
package boone.io;

import boone.io.BooneIOException;
import boone.io.Storable;
import boone.util.StreamParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public abstract class IOFilter {
    protected File file;
    protected boolean compressed;
    protected Object parser;
    protected Writer writer;
    protected int streamSize;

    public IOFilter() {
    }

    public IOFilter(File file) {
        this.file = file;
    }

    public void reset() {
        if (this.parser != null) {
            this.parser = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.reset();
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public void setCompressed(boolean bl) {
        this.compressed = bl;
    }

    public int getStreamSize() {
        return this.streamSize;
    }

    public boolean isStreaming() {
        return this.streamSize > 0;
    }

    protected List<Double> readValues(StreamParser streamParser, int n, char c, List<Double> list) throws IOException {
        if (list == null) {
            list = new ArrayList<Double>(n);
        }
        for (int i = 0; i < n; ++i) {
            if (streamParser.readState < 0) {
                throw new BooneIOException.Parsing("Incorrect number of values in pattern file!");
            }
            try {
                streamParser.readSpace();
                list.add(streamParser.readFloatNumber());
            }
            catch (NumberFormatException numberFormatException) {
                throw new BooneIOException.Parsing("Bad number format in pattern file!");
            }
            if (streamParser.readUntilCharOrNewline(c)) {
                streamParser.nextChar();
                continue;
            }
            streamParser.readLine();
        }
        return list;
    }

    protected InputStream createInputStream() throws IOException {
        InputStream inputStream = new FileInputStream(this.file);
        if (this.compressed) {
            inputStream = new GZIPInputStream(inputStream);
        }
        return inputStream;
    }

    protected OutputStream createOutputStream() throws IOException {
        OutputStream outputStream = new FileOutputStream(this.file);
        if (this.compressed) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        return outputStream;
    }

    public abstract Storable load(Storable var1) throws IOException;

    public abstract void save(Storable var1) throws IOException;
}

