/*
 * Decompiled with CFR 0.152.
 */
package boone.io;

import boone.PatternSet;
import boone.io.IOFilter;
import boone.io.Storable;
import boone.util.StreamParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class CSVPatternFilter
extends IOFilter {
    private char separator;
    private int inputCount;
    private int targetCount;
    private boolean header;

    public CSVPatternFilter(int n, int n2) {
        this(',', n, n2, false, 0);
    }

    public CSVPatternFilter(char c, int n, int n2, boolean bl, int n3) {
        this.separator = c;
        this.inputCount = n;
        this.targetCount = n2;
        this.header = bl;
        this.streamSize = n3;
    }

    @Override
    public void reset() {
        if (this.writer != null) {
            ((PrintWriter)this.writer).println("# Generated by Boone CSV Filter.");
        }
        super.reset();
    }

    @Override
    public Storable load(Storable storable) throws IOException {
        Object object;
        if (this.parser == null) {
            object = this.createInputStream();
            this.parser = new StreamParser((InputStream)object);
            if (this.header) {
                ((StreamParser)this.parser).readLine();
            }
        }
        object = (PatternSet)storable;
        StreamParser streamParser = (StreamParser)this.parser;
        long l = 0L;
        while (streamParser.readState >= 0) {
            streamParser.readSpace();
            if (streamParser.readState < 0) break;
            List<Double> list = this.readValues(streamParser, this.inputCount, this.separator, null);
            ((PatternSet)object).getInputs().add(list);
            ++l;
            if (this.targetCount > 0) {
                List<Double> list2 = this.readValues(streamParser, this.targetCount, this.separator, null);
                ((PatternSet)object).getTargets().add(list2);
            }
            streamParser.readLine();
            if (l != (long)this.streamSize) continue;
            break;
        }
        return object;
    }

    @Override
    public void save(Storable storable) throws IOException {
        Object object;
        if (this.writer == null) {
            object = this.createOutputStream();
            this.writer = new PrintWriter((OutputStream)object);
        }
        object = (PatternSet)storable;
        PrintWriter printWriter = (PrintWriter)this.writer;
        StringBuffer stringBuffer = ((PatternSet)object).writeValues(this.separator, false, false);
        printWriter.print(stringBuffer);
        printWriter.flush();
    }

    @Override
    protected List<Double> readValues(StreamParser streamParser, int n, char c, List<Double> list) {
        if (list == null) {
            list = new ArrayList<Double>(n);
        }
        if (streamParser.curChar == '\n') {
            return list;
        }
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            if (streamParser.curChar == '\"') {
                streamParser.nextChar();
                streamParser.readUntil('\"');
            } else {
                try {
                    d = streamParser.readFloatNumber();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            list.add(d);
            if (!streamParser.readUntilCharOrNewline(c)) break;
            streamParser.nextChar();
        }
        return list;
    }
}

