/*
 * Decompiled with CFR 0.152.
 */
package boone.io;

import boone.io.BooneIOException;
import boone.io.IOFilter;
import boone.io.Storable;
import boone.util.Xml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jdom2.Document;
import org.jdom2.Element;

public class BooneFilter
extends IOFilter {
    private String typeName;

    public BooneFilter() {
    }

    public BooneFilter(File file, String string) {
        super(file);
        this.typeName = string;
    }

    public BooneFilter(String string, boolean bl) {
        this.typeName = string;
        this.compressed = bl;
    }

    @Override
    public void reset() {
    }

    @Override
    public void save(Storable storable) throws IOException {
        Document document = Xml.buildDocument();
        Element element = new Element("boone");
        document.setRootElement(element);
        storable.toXML(element);
        OutputStream outputStream = this.createOutputStream();
        Xml.saveDocument(document, outputStream);
    }

    @Override
    public Storable load(Storable storable) throws IOException {
        InputStream inputStream = this.createInputStream();
        Document document = Xml.buildDocument(inputStream);
        Element element = document.getRootElement();
        String string = element.getName();
        if (!string.equals("boone")) {
            throw new BooneIOException.Parsing("Invalid file, not in Boone XML format!");
        }
        if (storable == null) {
            storable = Xml.getStorable(element, this.typeName);
        } else {
            if (element.getChild(this.typeName) != null) {
                element = element.getChild(this.typeName);
            }
            storable.fromXML(element);
        }
        return storable;
    }
}

