/*
 * Decompiled with CFR 0.152.
 */
package boone;

import boone.io.BooneFilter;
import boone.io.IOFilter;
import boone.io.Storable;
import boone.util.Conversion;
import boone.util.Patterns;
import boone.util.Xml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Element;

public class PatternSet
implements Storable,
Cloneable {
    protected ArrayList<String> names = new ArrayList();
    protected List<List<Double>> inputs = new ArrayList<List<Double>>();
    protected List<List<Double>> targets = new ArrayList<List<Double>>();
    protected List<List<Double>> outputs = new ArrayList<List<Double>>();
    protected Properties props = new Properties();
    protected IOFilter filter;
    private int currentIndex;

    public PatternSet() {
        this(new BooneFilter("set", true));
    }

    public PatternSet(IOFilter iOFilter) {
        this.filter = iOFilter;
    }

    public PatternSet clone() throws CloneNotSupportedException {
        ArrayList<Double> arrayList;
        PatternSet patternSet = (PatternSet)super.clone();
        patternSet.names = new ArrayList<String>(this.names);
        patternSet.inputs = new ArrayList<List<Double>>();
        for (List<Double> list : this.inputs) {
            arrayList = null;
            if (list != null) {
                arrayList = new ArrayList<Double>(list.size());
                arrayList.addAll(list);
            }
            patternSet.inputs.add(arrayList);
        }
        patternSet.targets = new ArrayList<List<Double>>();
        for (List<Double> list : this.targets) {
            arrayList = null;
            if (list != null) {
                arrayList = new ArrayList(list.size());
                arrayList.addAll(list);
            }
            patternSet.targets.add(arrayList);
        }
        patternSet.outputs = new ArrayList<List<Double>>();
        for (List<Double> list : this.outputs) {
            arrayList = null;
            if (list != null) {
                arrayList = new ArrayList(list.size());
                arrayList.addAll(list);
            }
            patternSet.outputs.add(arrayList);
        }
        patternSet.setProperties((Properties)this.props.clone());
        return patternSet;
    }

    public boolean hasMoreElements() {
        boolean bl;
        boolean bl2 = bl = this.currentIndex < this.inputs.size() && this.currentIndex < this.targets.size();
        if (!bl) {
            this.currentIndex = 0;
            if (this.filter.isStreaming()) {
                this.clear();
                try {
                    this.filter.load(this);
                }
                catch (IOException iOException) {
                    System.err.println("Could not stream data!");
                    iOException.printStackTrace();
                    return false;
                }
                boolean bl3 = bl = this.size() > 0;
                if (bl) {
                    this.pretty();
                } else {
                    this.filter.reset();
                }
            }
        }
        return bl;
    }

    public int getNextElement() {
        return this.currentIndex++;
    }

    public ArrayList<String> getNames() {
        return this.names;
    }

    public List<List<Double>> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<List<Double>> list) {
        this.inputs = list;
    }

    public List<Double> getInput(int n) {
        return this.getFeature(n, this.inputs);
    }

    public boolean addInput(List<Double> list) {
        return this.addFeature(list, this.inputs);
    }

    public List<List<Double>> getTargets() {
        return this.targets;
    }

    public void setTargets(List<List<Double>> list) {
        this.targets = list;
    }

    public List<Double> getTarget(int n) {
        return this.getFeature(n, this.targets);
    }

    public List<List<Double>> getOutputs() {
        return this.outputs;
    }

    public List<Double> getOutput(int n) {
        return this.getFeature(n, this.outputs);
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public IOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IOFilter iOFilter) {
        this.filter = iOFilter;
    }

    public int size() {
        return this.getInputs().size();
    }

    public int getInputPatternSize() {
        return this.getInputs().size() <= 0 ? 0 : this.getInputs().get(0).size();
    }

    public int getTargetPatternSize() {
        for (int i = 0; i < this.getTargets().size(); ++i) {
            if (this.getTargets().get(i) == null || this.getTargets().get(i).size() == 0) continue;
            return this.getTargets().get(i).size();
        }
        return 0;
    }

    public int getOutputPatternSize() {
        return this.getOutputs().size() <= 0 ? 0 : this.getOutputs().get(0).size();
    }

    public PatternSet load(File file) throws IOException {
        this.filter.setFile(file);
        return this.load(this.filter);
    }

    public PatternSet load(IOFilter iOFilter) throws IOException {
        if (iOFilter.getFile() == null) {
            throw new IOException("No file to load from!");
        }
        iOFilter.load(this);
        this.pretty();
        return this;
    }

    public void save(File file) throws IOException {
        this.filter.setFile(file);
        this.save(this.filter);
    }

    public void save(IOFilter iOFilter) throws IOException {
        iOFilter.save(this);
        if (iOFilter.isStreaming()) {
            this.currentIndex = this.size();
        } else {
            iOFilter.reset();
        }
    }

    public void shuffle() {
        Patterns.shuffle(this, this.size());
    }

    @Override
    public void fromXML(Element element) {
        for (Element element2 : element.getChildren("pattern")) {
            this.names.add(Xml.getProperty(element2, "name", String.valueOf(this.names.size())));
            String string = Xml.getProperty(element2, "input", null);
            this.inputs.add(Conversion.parseDouble(string));
            string = Xml.getProperty(element2, "target", null);
            this.targets.add(Conversion.parseDouble(string));
            string = Xml.getProperty(element2, "output", null);
            this.outputs.add(Conversion.parseDouble(string));
        }
        for (Element element2 : element.getChildren("property")) {
            this.props.setProperty(Xml.getProperty(element2, "name", ""), Xml.getProperty(element2, "value", ""));
        }
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "set", this);
        int n = this.inputs.size() >= this.targets.size() ? this.inputs.size() : this.targets.size();
        n = n >= this.outputs.size() ? n : this.outputs.size();
        for (int i = 0; i < n; ++i) {
            Element object = Xml.addChildTo(element2, "pattern", null);
            if (i < this.names.size()) {
                object.setAttribute("name", this.names.get(i));
            }
            if (i < this.inputs.size()) {
                Xml.addChildTo(object, "input", Conversion.constructDoubleList(this.inputs.get(i)));
            }
            if (i < this.targets.size()) {
                Xml.addChildTo(object, "target", Conversion.constructDoubleList(this.targets.get(i)));
            }
            if (i >= this.outputs.size()) continue;
            Xml.addChildTo(object, "output", Conversion.constructDoubleList(this.outputs.get(i)));
        }
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            Element element3 = Xml.addChildTo(element2, "property", null);
            element3.setAttribute("name", entry.getKey().toString());
            element3.setAttribute("value", entry.getValue().toString());
        }
        return element2;
    }

    public StringBuffer writeValues(char c, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (bl && this.getNames().size() > i) {
                stringBuffer.append("#").append(this.getNames().get(i)).append('\n');
            }
            List<Double> list = this.getInputs().get(i);
            for (Double d : list) {
                stringBuffer.append(d).append(c);
            }
            if (bl2) {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer.append('\n');
            }
            if (i >= this.getTargets().size() || (list = this.getTargets().get(i)) == null) continue;
            for (Double d : list) {
                stringBuffer.append(d).append(c);
            }
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    public int getTargetLabelCount() {
        return this.getProperties().size();
    }

    public String getTargetLabel(int n) {
        return this.getProperties().getProperty(String.valueOf(n), null);
    }

    public void setTargetLabel(int n, String string) {
        this.getProperties().setProperty(String.valueOf(n), string);
    }

    public String getTargetLabelOfPattern(int n) {
        int n2 = this.getTargets().get(n).get(0).intValue();
        return this.getProperties().getProperty(String.valueOf(n2), null);
    }

    public String toString() {
        return this.writeValues(' ', true, true).toString();
    }

    private void clear() {
        this.names.clear();
        this.inputs.clear();
        this.targets.clear();
        this.outputs.clear();
    }

    private void pretty() {
        if (this.names.size() == 0) {
            for (int i = 0; i < this.size(); ++i) {
                this.names.add(String.valueOf(i));
            }
        }
    }

    private List<Double> getFeature(int n, List<List<Double>> list) {
        if (n >= list.get(0).size()) {
            return null;
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
        for (List<Double> list2 : list) {
            arrayList.add(list2.get(n));
        }
        return arrayList;
    }

    private boolean addFeature(List<Double> list, List<List<Double>> list2) {
        if (list.size() < list2.size()) {
            return false;
        }
        int n = 0;
        for (List<Double> list3 : list2) {
            list3.add(list.get(n++));
        }
        return true;
    }
}

