/*
 * Decompiled with CFR 0.152.
 */
package boone;

import boone.BrainPart;
import boone.Link;
import boone.map.Function;
import boone.map.Position;
import boone.util.Common;
import boone.util.Xml;
import java.util.ArrayList;
import org.jdom2.Element;

public class Neuron
extends BrainPart
implements Comparable {
    protected Position position;
    protected boolean inputNeuron;
    protected boolean outputNeuron;
    protected int layer = -1;
    protected boolean usingBias = true;
    protected double errorSignal;
    protected double externalInput;
    protected double linkInput;
    protected double input;
    protected double output;
    protected ArrayList<Link> links;

    public Neuron() {
        this(new Function.Sigmoid());
    }

    public Neuron(Function function) {
        this.activationFn = function;
        this.links = new ArrayList();
    }

    public Neuron(boolean bl, boolean bl2, boolean bl3) {
        this(bl ? new Function.Identity() : new Function.Sigmoid());
        this.inputNeuron = bl;
        this.outputNeuron = bl2;
        this.usingBias = bl3;
    }

    @Override
    public Neuron clone() {
        Neuron neuron = (Neuron)super.clone();
        if (this.position != null) {
            neuron.position = this.position.clone();
        }
        neuron.links = new ArrayList();
        neuron.setID(-1L);
        return neuron;
    }

    public int compareTo(Object object) {
        Neuron neuron = (Neuron)object;
        if (this.getLayer() < neuron.getLayer()) {
            return -1;
        }
        if (this.getLayer() > neuron.getLayer()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.errorSignal = 0.0;
    }

    @Override
    public void calculate() {
        this.input = this.linkInput + this.externalInput;
        if (this.usingBias) {
            this.input += this.weight;
        }
        this.output = this.activationFn.map(this.input);
        this.linkInput = 0.0;
    }

    public void propagateOutput() {
        for (Link link : this.links) {
            if (!link.isOutputOf(this)) continue;
            link.propagate();
        }
    }

    public boolean isInputNeuron() {
        return this.inputNeuron;
    }

    public void setInputNeuron(boolean bl) {
        this.inputNeuron = bl;
    }

    public boolean isOutputNeuron() {
        return this.outputNeuron;
    }

    public void setOutputNeuron(boolean bl) {
        this.outputNeuron = bl;
    }

    public boolean isHiddenNeuron() {
        return !this.inputNeuron && !this.outputNeuron;
    }

    public Position getPosition() {
        if (this.position == null) {
            this.position = new Position();
        }
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public double getExternalInput() {
        return this.externalInput;
    }

    public void setExternalInput(double d) {
        this.externalInput = d;
    }

    public double getInput() {
        return this.input;
    }

    public void setInput(double d) {
        this.input = d;
    }

    public double getOutput() {
        return this.output;
    }

    public void setOutput(double d) {
        this.output = d;
    }

    public double getBias() {
        return super.getWeight();
    }

    public void setBias(double d) {
        super.setWeight(d);
    }

    public void addToBias(double d) {
        super.addToWeight(d);
    }

    public double getErrorSignal() {
        return this.errorSignal;
    }

    public void setErrorSignal(double d) {
        this.errorSignal = d;
    }

    public void setLinkInput(double d) {
        this.linkInput = d;
    }

    public void addLinkInput(Link link) {
        this.linkInput += link.getValue();
    }

    public double getLinkInput() {
        return this.linkInput;
    }

    public boolean isUsingBias() {
        return this.usingBias;
    }

    public void setUsingBias(boolean bl) {
        this.usingBias = bl;
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Link getLink(int n) {
        return this.links.get(n);
    }

    public ArrayList<Link> getLinks() {
        return this.links;
    }

    public Link getLinkTo(Neuron neuron) {
        for (Link link : this.links) {
            if (link.getSink() == neuron && link.getSource() == this) {
                return link;
            }
            if (link.getSource() != neuron || link.getSink() != this || !link.isDirected()) continue;
            return link;
        }
        return null;
    }

    public int getInputLinkCount() {
        int n = 0;
        for (Link link : this.links) {
            if (!link.isInputOf(this)) continue;
            ++n;
        }
        return n;
    }

    public Link getInputLink(int n) {
        int n2 = 0;
        for (Link link : this.links) {
            if (!link.isInputOf(this) || n2++ != n) continue;
            return link;
        }
        return null;
    }

    public int getOutputLinkCount() {
        int n = 0;
        for (Link link : this.links) {
            if (!link.isOutputOf(this)) continue;
            ++n;
        }
        return n;
    }

    public Link getOutputLink(int n) {
        int n2 = 0;
        for (Link link : this.links) {
            if (!link.isOutputOf(this) || n2++ != n) continue;
            return link;
        }
        return null;
    }

    @Override
    public void fromXML(Element element) {
        super.fromXML(element);
        this.inputNeuron = Xml.getDualProperty(element, "in", "inputNeuron", false);
        this.outputNeuron = Xml.getDualProperty(element, "ot", "outputNeuron", false);
        this.layer = Xml.getDualProperty(element, "ly", "layer", -1);
        this.usingBias = Xml.getProperty(element, "usingBias", this.usingBias);
        this.usingBias = Xml.getDualProperty(element, "bi", "usingBias", true);
        this.setBias(Xml.getProperty(element, "bias", this.getBias()));
        this.activationFn = (Function)Xml.getStorable(element, "activationFn");
        this.position = (Position)Xml.getStorable(element, "position");
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "neuron", this);
        super.toXML(element2);
        if (this.inputNeuron) {
            element2.setAttribute("in", String.valueOf(true));
        }
        if (this.outputNeuron) {
            element2.setAttribute("ot", String.valueOf(true));
        }
        if (this.layer != -1) {
            element2.setAttribute("ly", String.valueOf(this.layer));
        }
        if (!this.usingBias) {
            element2.setAttribute("bi", String.valueOf(false));
        }
        this.activationFn.toXML(element2);
        if (this.position != null) {
            this.position.toXML(element2);
        }
        return element2;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("< ");
        if (this.layer != -1) {
            stringBuilder.append("L").append(this.layer).append(" ");
        }
        stringBuilder.append(this.getName()).append(" ").append(this.getID()).append(": ");
        if (this.usingBias) {
            stringBuilder.append("bias = ").append(Common.fixedPoint.format(this.getBias())).append(", ");
        }
        stringBuilder.append("out = ").append(Common.fixedPoint.format(this.getOutput())).append(">");
        return stringBuilder.toString();
    }
}

