/*
 * Decompiled with CFR 0.152.
 */
package boone;

import boone.BrainPart;
import boone.Link;
import boone.Neuron;
import boone.Trainer;
import boone.io.BooneFilter;
import boone.io.IOFilter;
import boone.io.Storable;
import boone.neurons.NeuronList;
import boone.structure.Layer;
import boone.structure.Map;
import boone.util.CloneException;
import boone.util.Common;
import boone.util.Nets;
import boone.util.Xml;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom2.Element;

public class NeuralNet
implements Storable,
Cloneable {
    public static final int UNKNOWN = 0;
    public static final int FEEDFORWARD = 1;
    public static final int RECURRENT = 2;
    protected int topology;
    protected List<Layer> layers;
    protected NeuronList neurons;
    protected NeuronList inputNeurons;
    protected NeuronList outputNeurons;
    protected ArrayList<Link> links;
    protected Trainer trainer;
    protected int maxCycles = 1;
    protected boolean zeroInputAfterFirstCycle;
    protected IOFilter filter;
    public Properties props = new Properties();

    public NeuralNet() {
        this.layers = new ArrayList<Layer>();
        this.neurons = new NeuronList();
        this.inputNeurons = new NeuronList();
        this.outputNeurons = new NeuronList();
        this.links = new ArrayList();
        this.filter = new BooneFilter("net", true);
    }

    public int getTopology() {
        return this.topology;
    }

    public void setTopology(int n) {
        this.topology = n;
    }

    public IOFilter getFilter() {
        return this.filter;
    }

    public void setFilter(IOFilter iOFilter) {
        this.filter = iOFilter;
    }

    public int getNeuronCount() {
        return this.neurons.size();
    }

    public Neuron getNeuron(int n) {
        return (Neuron)this.neurons.get(n);
    }

    public int getNeuronIndex(Neuron neuron) {
        return this.neurons.indexOf(neuron);
    }

    public Neuron getNeuronID(long l) {
        return Nets.searchNeuron(this.neurons, l);
    }

    public int getInputNeuronCount() {
        return this.inputNeurons.size();
    }

    public Neuron getInputNeuron(int n) {
        return (Neuron)this.inputNeurons.get(n);
    }

    public int getOutputNeuronCount() {
        return this.outputNeurons.size();
    }

    public Neuron getOutputNeuron(int n) {
        return (Neuron)this.outputNeurons.get(n);
    }

    public int getOutputNeuronIndex(Neuron neuron) {
        return this.outputNeurons.indexOf(neuron);
    }

    public int getHiddenNeuronCount() {
        int n = 0;
        for (Neuron neuron : this.neurons) {
            if (!neuron.isHiddenNeuron()) continue;
            ++n;
        }
        return n;
    }

    public void addNeuron(Neuron neuron) {
        if (neuron == null) {
            return;
        }
        if (neuron.getID() < 0L) {
            neuron.setID(BrainPart.getUniqueID());
        }
        this.neurons.add(neuron);
        if (neuron.isInputNeuron()) {
            this.inputNeurons.add(neuron);
        }
        if (neuron.isOutputNeuron()) {
            this.outputNeurons.add(neuron);
        }
        this.topology = 0;
    }

    public void addLayer(Layer layer) {
        this.layers.add(layer);
        layer.setLevel(this.layers.size() - 1);
        for (Map map : layer.getMaps()) {
            for (Neuron neuron : map.getNeurons()) {
                neuron.setLayer(layer.getLevel());
                this.addNeuron(neuron);
                for (Link link : neuron.getLinks()) {
                    if (!link.isInputOf(neuron)) continue;
                    this.addLink(link);
                }
            }
        }
    }

    public void replaceNeuron(Neuron neuron, Neuron neuron2) {
        if (neuron == neuron2) {
            return;
        }
        neuron2.setID(neuron.getID());
        Common.replace(this.neurons, neuron, neuron2);
        Common.replace(this.inputNeurons, neuron, neuron2);
        Common.replace(this.outputNeurons, neuron, neuron2);
        while (neuron.getOutputLinkCount() > 0) {
            neuron.getOutputLink(0).replaceNeuron(neuron, neuron2);
        }
        while (neuron.getLinkCount() > 0) {
            neuron.getLink(0).replaceNeuron(neuron, neuron2);
        }
    }

    public boolean removeNeuron(Neuron neuron) {
        for (Link link : neuron.links) {
            if (link.isInputOf(neuron)) {
                link.clearSink();
            }
            if (!link.isOutputOf(neuron)) continue;
            link.clearSource();
        }
        if (neuron.isInputNeuron()) {
            this.inputNeurons.remove(neuron);
        }
        if (neuron.isOutputNeuron()) {
            this.outputNeurons.remove(neuron);
        }
        this.topology = 0;
        return this.neurons.remove(neuron);
    }

    public int getLinkCount() {
        return this.links.size();
    }

    public Link getLink(int n) {
        return this.links.get(n);
    }

    public Link getLinkID(long l) {
        return Nets.searchLink(this.links, l);
    }

    public void addLink(Link link) {
        if (link == null) {
            return;
        }
        if (link.getID() < 0L) {
            link.setID(BrainPart.getUniqueID());
        }
        this.links.add(link);
        this.topology = 0;
    }

    public void replaceLink(Link link, Link link2) {
        Common.replace(this.links, link, link2);
        link2.replaceFrom(link);
    }

    public boolean removeLink(Link link) {
        link.disconnect();
        this.topology = 0;
        return this.links.remove(link);
    }

    public void setInput(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            ((Neuron)this.inputNeurons.get((int)i)).externalInput = dArray[i];
        }
    }

    public void setInput(List<Double> list) {
        for (int i = 0; i < list.size(); ++i) {
            ((Neuron)this.inputNeurons.get((int)i)).externalInput = list.get(i);
        }
    }

    public double[] getOutput(double[] dArray) {
        if (dArray == null || dArray.length < this.outputNeurons.size()) {
            dArray = new double[this.outputNeurons.size()];
        }
        for (int i = 0; i < this.outputNeurons.size(); ++i) {
            dArray[i] = ((Neuron)this.outputNeurons.get(i)).getOutput();
        }
        return dArray;
    }

    public void randomize() {
        int n;
        for (n = 0; n < this.getNeuronCount(); ++n) {
            this.getNeuron(n).randomize();
        }
        for (n = 0; n < this.getLinkCount(); ++n) {
            this.getLink(n).randomize();
        }
    }

    private void checkTopology() {
        if (this.neurons.sortTopological()) {
            this.topology = 1;
        } else {
            this.topology = 2;
            this.neurons.sortRandom();
        }
    }

    public void innervate() {
        int n;
        if (this.topology == 0) {
            this.checkTopology();
        }
        if (this.topology == 1) {
            this.activate();
        } else {
            for (n = 0; n < this.maxCycles; ++n) {
                this.activate();
                if (!this.zeroInputAfterFirstCycle || n != 0) continue;
                for (int i = 0; i < this.inputNeurons.size(); ++i) {
                    this.getInputNeuron(i).setExternalInput(0.0);
                }
            }
        }
        for (n = this.neurons.size() - 1; n >= 0; --n) {
            ((Neuron)this.neurons.get(n)).setLinkInput(0.0);
        }
    }

    private void activate() {
        for (Neuron neuron : this.neurons) {
            neuron.calculate();
            neuron.propagateOutput();
        }
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NeuralNet: ").append(this.hashCode()).append("\n");
        stringBuilder.append(this.trainer).append("\n");
        for (n = 0; n < this.neurons.size(); ++n) {
            stringBuilder.append(this.getNeuron(n)).append("\n");
        }
        for (n = 0; n < this.links.size(); ++n) {
            stringBuilder.append(this.getLink(n)).append("\n");
        }
        return stringBuilder.toString();
    }

    public void setTrainer(Trainer trainer) {
        this.trainer = trainer;
        if (trainer != null) {
            trainer.setNetwork(this);
        }
    }

    public Trainer getTrainer() {
        return this.trainer;
    }

    public int getMaxCycles() {
        return this.maxCycles;
    }

    public void setMaxCycles(int n) {
        this.maxCycles = n;
    }

    public void setZeroInputAfterFirstCycle(boolean bl) {
        this.zeroInputAfterFirstCycle = bl;
    }

    public boolean getZeroInputAfterFirstCycle() {
        return this.zeroInputAfterFirstCycle;
    }

    public static NeuralNet load(File file, IOFilter iOFilter) throws IOException {
        iOFilter.setFile(file);
        NeuralNet neuralNet = (NeuralNet)iOFilter.load(null);
        if (neuralNet != null) {
            neuralNet.setFilter(iOFilter);
        }
        return neuralNet;
    }

    public void save(File file) throws IOException {
        this.filter.setFile(file);
        this.filter.save(this);
    }

    @Override
    public void fromXML(Element element) {
        BrainPart brainPart2;
        this.trainer = (Trainer)Xml.getStorable(element, "trainer");
        if (this.trainer != null) {
            this.trainer.setNetwork(this);
        }
        this.maxCycles = Xml.getProperty(element, "maxCycles", this.maxCycles);
        this.topology = Xml.getProperty(element, "topology", this.topology);
        List list = element.getChildren();
        for (Object object : list) {
            if (!object.getName().equals("neuron") || (brainPart2 = (Neuron)Xml.getStorable((Element)object)) == null) continue;
            this.addNeuron((Neuron)brainPart2);
        }
        for (Object object : list) {
            if (!object.getName().equals("link") || (brainPart2 = (Link)Xml.getStorable((Element)object)) == null) continue;
            ((Link)brainPart2).fromXML((Element)object, this);
            this.addLink((Link)brainPart2);
        }
        Element element2 = element.getChild("properties");
        if (element2 != null) {
            for (BrainPart brainPart2 : element2.getAttributes()) {
                this.props.setProperty(brainPart2.getName(), brainPart2.getValue());
            }
        }
    }

    @Override
    public Element toXML(Element element) {
        Element element2 = Xml.addStorable(element, "net", this);
        element2.setAttribute("maxCycles", String.valueOf(this.maxCycles));
        element2.setAttribute("topology", String.valueOf(this.topology));
        for (Layer object : this.layers) {
            object.toXML(element2);
        }
        if (this.trainer != null) {
            this.trainer.toXML(element2);
        }
        for (Neuron neuron : this.neurons) {
            neuron.toXML(element2);
        }
        for (Link link : this.links) {
            if (link.isDangling()) continue;
            link.toXML(element2);
        }
        Iterator<Storable> iterator = Xml.addChildTo(element2, "properties", null);
        for (Map.Entry<Object, Object> entry : this.props.entrySet()) {
            iterator.setAttribute(entry.getKey().toString(), entry.getValue().toString());
        }
        return element2;
    }

    public NeuralNet clone() {
        try {
            BrainPart brainPart;
            NeuralNet neuralNet = (NeuralNet)super.clone();
            if (this.trainer != null) {
                Trainer trainer;
                neuralNet.trainer = trainer = this.trainer.clone();
                trainer.setNetwork(neuralNet);
            }
            Hashtable<Neuron, Neuron> hashtable = new Hashtable<Neuron, Neuron>(this.neurons.size());
            neuralNet.neurons = new NeuronList();
            neuralNet.inputNeurons = new NeuronList();
            neuralNet.outputNeurons = new NeuronList();
            for (Neuron brainPart2 : this.neurons) {
                brainPart = brainPart2.clone();
                neuralNet.addNeuron((Neuron)brainPart);
                hashtable.put(brainPart2, (Neuron)brainPart);
            }
            neuralNet.links = new ArrayList();
            for (Link link : this.links) {
                brainPart = link.clone();
                if (link.getSource() == null) {
                    ((Link)brainPart).setSource(null);
                } else {
                    ((Link)brainPart).setSource((Neuron)hashtable.get(link.getSource()));
                }
                if (link.getSink() == null) {
                    ((Link)brainPart).setSink(null);
                } else {
                    ((Link)brainPart).setSink((Neuron)hashtable.get(link.getSink()));
                }
                neuralNet.addLink((Link)brainPart);
            }
            neuralNet.props = (Properties)this.props.clone();
            return neuralNet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new CloneException(cloneNotSupportedException);
        }
    }

    public void linkNet(NeuralNet neuralNet) {
        Link link = new Link();
        link.setName("Link");
        link.setWeight(1.0);
        if (this.getOutputNeuronCount() == neuralNet.getInputNeuronCount()) {
            int n;
            for (n = 0; n < this.getOutputNeuronCount(); ++n) {
                neuralNet.getInputNeuron(n).setInputNeuron(false);
                neuralNet.getNeuron(n).setExternalInput(0.0);
                this.getOutputNeuron(n).setOutputNeuron(false);
                Link link2 = link.clone();
                link2.setSource(this.getOutputNeuron(n));
                link2.setSink(neuralNet.getInputNeuron(n));
                this.addLink(link2);
            }
            this.outputNeurons = new NeuronList();
            for (n = 0; n < neuralNet.getNeuronCount(); ++n) {
                this.addNeuron(neuralNet.getNeuron(n));
            }
            for (n = 0; n < neuralNet.getLinkCount(); ++n) {
                this.addLink(neuralNet.getLink(n));
            }
            this.topology = 0;
        }
    }
}

